/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.item.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.NBTHelper;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;

public class DestructionCatalystItem
extends ToggleableItem {
    private static final String GUNPOWDER_TAG = "gunpowder";

    public DestructionCatalystItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack catalyst, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", NBTHelper.getInt(GUNPOWDER_TAG, catalyst));
        if (this.isEnabled(catalyst)) {
            tooltipBuilder.absorbActive(Items.f_42403_.m_7626_(new ItemStack((ItemLike)Items.f_42403_)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext itemUseContext) {
        Player player = itemUseContext.m_43723_();
        if (player != null && player.m_6047_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = itemUseContext.m_43722_();
        if (NBTHelper.getInt(GUNPOWDER_TAG, stack) > this.gunpowderCost() || player != null && player.m_7500_()) {
            if (this.doExplosion(itemUseContext.m_43725_(), itemUseContext.m_8083_(), itemUseContext.m_43719_()) && player != null && !player.m_7500_()) {
                NBTHelper.putInt(GUNPOWDER_TAG, stack, NBTHelper.getInt(GUNPOWDER_TAG, stack) - this.gunpowderCost());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack catalyst, Level world, Entity e, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L) {
            return;
        }
        if (!(e instanceof Player)) {
            return;
        }
        Player player = (Player)e;
        if (this.isEnabled(catalyst)) {
            int gunpowderCharge = NBTHelper.getInt(GUNPOWDER_TAG, catalyst);
            this.consumeAndCharge(player, this.gunpowderLimit() - gunpowderCharge, this.gunpowderWorth(), Items.f_42403_, 16, (int chargeToAdd) -> NBTHelper.putInt(GUNPOWDER_TAG, catalyst, gunpowderCharge + chargeToAdd));
        }
    }

    private int getExplosionRadius() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.explosionRadius.get();
    }

    private boolean perfectCube() {
        return (Boolean)Settings.COMMON.items.destructionCatalyst.perfectCube.get();
    }

    private boolean doExplosion(Level world, BlockPos pos, Direction direction) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        BlockPos origin = pos;
        if (Boolean.FALSE.equals(Settings.COMMON.items.destructionCatalyst.centeredExplosion.get())) {
            origin = pos.m_5484_(direction.m_122424_(), this.getExplosionRadius());
        }
        for (BlockPos target : BlockPos.m_121940_((BlockPos)origin.m_7918_(-this.getExplosionRadius(), -this.getExplosionRadius(), -this.getExplosionRadius()), (BlockPos)origin.m_7918_(this.getExplosionRadius(), this.getExplosionRadius(), this.getExplosionRadius()))) {
            double distance;
            if (!this.perfectCube() && (distance = origin.m_123331_((Vec3i)target)) >= (double)this.getExplosionRadius() || !this.isBreakable(ForgeRegistries.BLOCKS.getKey((Object)world.m_8055_(target).m_60734_()).toString())) continue;
            world.m_46597_(target, Blocks.f_50016_.m_49966_());
            if (world.f_46441_.m_188503_(2) == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)((float)target.m_123341_() + (world.f_46441_.m_188501_() - 0.5f)), (double)((float)target.m_123342_() + (world.f_46441_.m_188501_() - 0.5f)), (double)((float)target.m_123343_() + (world.f_46441_.m_188501_() - 0.5f)), 0.0, 0.0, 0.0);
            }
            destroyedSomething = true;
            if (!playOnce) continue;
            world.m_5594_(null, target, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(world.f_46441_) * 0.2f) * 0.7f);
            playOnce = false;
        }
        return destroyedSomething;
    }

    private boolean isBreakable(String id) {
        return ((List)Settings.COMMON.items.destructionCatalyst.mundaneBlocks.get()).contains(id);
    }

    private int gunpowderCost() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderCost.get();
    }

    private int gunpowderWorth() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderWorth.get();
    }

    private int gunpowderLimit() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderLimit.get();
    }
}

