/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.client.render.IRendererWithModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class GauntletEnergyRenderer
implements IRendererWithModel,
IRenderer<GauntletEntity> {
    private final GeoModel<GauntletEntity> geoModel;
    private final EntityRendererProvider.Context context;
    private final ResourceLocation armorTexture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/obsidilith_armor.png");
    private RenderHelper geoModelProvider;
    private GauntletEntity gauntletEntity;
    private RenderType type;

    public GauntletEnergyRenderer(GeoModel<GauntletEntity> geoModel, EntityRendererProvider.Context context) {
        this.geoModel = geoModel;
        this.context = context;
    }

    @Override
    public void render(GauntletEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        float renderAge = (float)entity.f_19797_ + partialTicks;
        float textureOffset = renderAge * 0.01f;
        if (this.geoModelProvider == null) {
            this.geoModelProvider = new RenderHelper(entity, this.geoModel, this.context);
        }
        this.gauntletEntity = entity;
        this.type = RenderType.m_110436_((ResourceLocation)this.armorTexture, (float)textureOffset, (float)textureOffset);
    }

    @Override
    public void render(BakedGeoModel model, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        VertexConsumer energyBuffer = buffer.m_6299_(this.type);
        if (this.gauntletEntity == null) {
            return;
        }
        if (this.type == null) {
            return;
        }
        float renderAlpha = this.gauntletEntity.energyShieldHandler.getRenderAlpha();
        if (renderAlpha == 0.0f) {
            return;
        }
        float lerpedAlpha = Mth.m_14179_((float)partialTicks, (float)(renderAlpha - 0.1f), (float)renderAlpha);
        if (this.geoModelProvider == null) {
            return;
        }
        this.geoModelProvider.actuallyRender(poseStack, (Entity)this.gauntletEntity, model, this.type, buffer, energyBuffer, false, partialTicks, packedLightIn, OverlayTexture.f_118083_, 0.8f * lerpedAlpha, 0.2f * lerpedAlpha, 0.2f * lerpedAlpha, lerpedAlpha);
    }

    private static class RenderHelper
    extends GeoEntityRenderer<GauntletEntity> {
        private final GauntletEntity gauntletEntity;

        public RenderHelper(GauntletEntity gauntletEntity, GeoModel<GauntletEntity> parentModel, EntityRendererProvider.Context context) {
            super(context, parentModel);
            this.gauntletEntity = gauntletEntity;
        }

        public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.1f, 1.05f, 1.1f);
            super.renderCube(poseStack, cube, buffer, 0xF000F0, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }

        public GauntletEntity getAnimatable() {
            return this.gauntletEntity;
        }
    }
}

