/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.doubleblock;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.common.IPlantable;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.doubleblock.PlantablePredicate;

public enum SolidityCheck {
    NONE(be -> false, (be, side, plant) -> false),
    FIRST(be -> be.getCamo().isSolid((BlockGetter)be.m_58904_(), be.m_58899_()), (be, side, plant) -> FramedBlockEntity.canSustainPlant(be, be.getCamo(), side, plant)),
    SECOND(be -> be.getCamoTwo().isSolid((BlockGetter)be.m_58904_(), be.m_58899_()), (be, side, plant) -> FramedBlockEntity.canSustainPlant(be, be.getCamoTwo(), side, plant)),
    BOTH(be -> FIRST.isSolid((FramedDoubleBlockEntity)be) && SECOND.isSolid((FramedDoubleBlockEntity)be), (be, side, plant) -> FIRST.canSustainPlant(be, side, plant) && SECOND.canSustainPlant(be, side, plant));

    private final Predicate<FramedDoubleBlockEntity> predicate;
    private final PlantablePredicate plantablePredicate;

    private SolidityCheck(Predicate<FramedDoubleBlockEntity> predicate, PlantablePredicate plantablePredicate) {
        this.predicate = predicate;
        this.plantablePredicate = plantablePredicate;
    }

    public boolean isSolid(FramedDoubleBlockEntity be) {
        return this.predicate.test(be);
    }

    public boolean canSustainPlant(FramedDoubleBlockEntity be, Direction side, IPlantable plant) {
        return this.plantablePredicate.test(be, side, plant);
    }
}

