/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedStackedCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.blockentity.doubled.FramedStackedInnerCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedStackedCornerSlopePanelWallBlock
extends AbstractFramedDoubleBlock {
    public FramedStackedCornerSlopePanelWallBlock(BlockType blockType) {
        super(blockType);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.getBlockType() == BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_STACKED_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_()) break;
                side = dir;
                break;
            }
            case FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.m_82450_();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> new FramedStackedCornerSlopePanelWallBlockEntity(pos, state);
            case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> new FramedStackedInnerCornerSlopePanelWallBlockEntity(pos, state);
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction otherDir;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)otherDir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(switch (rot) {
                case HorizontalRotation.UP -> {
                    otherDir = dir.m_122428_();
                    yield true;
                }
                case HorizontalRotation.DOWN -> {
                    otherDir = dir.m_122427_();
                    yield false;
                }
                case HorizontalRotation.RIGHT -> {
                    otherDir = dir.m_122427_();
                    yield true;
                }
                case HorizontalRotation.LEFT -> {
                    otherDir = dir.m_122428_();
                    yield false;
                }
                default -> throw new IncompatibleClassChangeError();
            }))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_STAIRS.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)otherDir.m_122424_())).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)((switch (rot) {
                case HorizontalRotation.UP -> {
                    otherDir = dir.m_122428_();
                    yield true;
                }
                case HorizontalRotation.DOWN -> {
                    otherDir = dir.m_122427_();
                    yield false;
                }
                case HorizontalRotation.RIGHT -> {
                    otherDir = dir.m_122427_();
                    yield true;
                }
                case HorizontalRotation.LEFT -> {
                    otherDir = dir.m_122428_();
                    yield false;
                }
                default -> throw new IncompatibleClassChangeError();
            }) ? Half.BOTTOM : Half.TOP))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            default -> throw new IllegalArgumentException("Invalid type for this block: " + this.getBlockType());
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (rot == HorizontalRotation.UP || rot == HorizontalRotation.RIGHT) {
            return DoubleBlockTopInteractionMode.EITHER;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == rotDir && edge == perpRotDir || side == perpRotDir && edge == rotDir) {
                    yield CamoGetter.FIRST;
                }
                if (side == dir && (edge == rotDir.m_122424_() || edge == perpRotDir.m_122424_())) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side.m_122434_() == dir.m_122434_() && (edge == rotDir.m_122424_() || edge == perpRotDir.m_122424_())) {
                    yield CamoGetter.FIRST;
                }
                if (side == rotDir.m_122424_() || side == perpRotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                if (side == rotDir && edge == perpRotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                if (side == perpRotDir && edge == rotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                if (side == dir) {
                    yield SolidityCheck.BOTH;
                }
                yield SolidityCheck.NONE;
            }
            case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                if (side == dir) {
                    yield SolidityCheck.BOTH;
                }
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == rot.withFacing(dir).m_122424_() || side == perpRotDir.m_122424_()) {
                    yield SolidityCheck.FIRST;
                }
                yield SolidityCheck.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }
}

