/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.forge;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class SoftFluidStackImpl
extends SoftFluidStack {
    public SoftFluidStackImpl(Holder<SoftFluid> fluid, int count, CompoundTag tag) {
        super(fluid, count, tag);
    }

    public static SoftFluidStack of(Holder<SoftFluid> fluid, int count, @Nullable CompoundTag tag) {
        return new SoftFluidStackImpl(fluid, count, tag);
    }

    public boolean isFluidEqual(FluidStack fluidStack) {
        return this.isFluidEqual(SoftFluidStackImpl.fromForgeFluid(fluidStack));
    }

    public static FluidStack toForgeFluid(SoftFluidStack softFluid) {
        FluidStack stack = new FluidStack(softFluid.fluid().getVanillaFluid(), SoftFluidStackImpl.bottlesToMB(softFluid.getCount()));
        List<String> nbtKey = softFluid.fluid().getNbtKeyFromItem();
        CompoundTag tag = softFluid.getTag();
        if (tag != null && !tag.m_128456_() && !stack.isEmpty() && nbtKey != null) {
            CompoundTag newCom = new CompoundTag();
            for (String k : nbtKey) {
                Tag c;
                if (k.equals("Bottle") && Utils.getID(stack.getFluid()).m_135827_().equals("immersiveengineering") || (c = tag.m_128423_(k)) == null) continue;
                newCom.m_128365_(k, c);
            }
            if (!newCom.m_128456_()) {
                stack.setTag(newCom);
            }
        }
        return stack;
    }

    public FluidStack toForgeFluid() {
        return SoftFluidStackImpl.toForgeFluid(this);
    }

    public static SoftFluidStack fromForgeFluid(FluidStack fluidStack) {
        int amount = SoftFluidStackImpl.MBtoBottles(fluidStack.getAmount());
        return SoftFluidStack.fromFluid(fluidStack.getFluid(), amount, fluidStack.hasTag() ? fluidStack.getTag().m_6426_() : null);
    }

    public static int bottlesToMB(int bottles) {
        return bottles * 250;
    }

    public static int MBtoBottles(int milliBuckets) {
        return (int)((float)milliBuckets / 250.0f);
    }
}

