/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;

public final class VoxelOutliner {
    private static final int MASK_EAST = 1;
    private static final int MASK_WEST = 2;
    private static final int MASK_UP = 4;
    private static final int MASK_DOWN = 8;
    private static final int MASK_SOUTH = 16;
    private static final int MASK_NORTH = 32;

    private VoxelOutliner() {
    }

    private static int maskOf(Collection<Direction> dirs) {
        int m = 0;
        for (Direction d : dirs) {
            switch (d) {
                case EAST: {
                    m |= 1;
                    break;
                }
                case WEST: {
                    m |= 2;
                    break;
                }
                case UP: {
                    m |= 4;
                    break;
                }
                case DOWN: {
                    m |= 8;
                    break;
                }
                case SOUTH: {
                    m |= 0x10;
                    break;
                }
                case NORTH: {
                    m |= 0x20;
                }
            }
        }
        return m;
    }

    public static List<Edge> computeShapeRenderableEdges(Level level, List<BlockPos> positions) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        positions.forEach(pos -> {
            BlockState state = level.m_8055_(pos);
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            Block patt2134$temp = state.m_60734_();
            if (patt2134$temp instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)patt2134$temp;
                VoxelShape finalShape = shape;
                shape = doubleBlock.getOtherPosition(state, (BlockPos)pos).map(otherPos -> {
                    BlockState otherState = level.m_8055_(otherPos);
                    VoxelShape otherShape = otherState.m_60808_((BlockGetter)level, otherPos);
                    otherShape = otherShape.m_83216_((double)(otherPos.m_123341_() - pos.m_123341_()), (double)(otherPos.m_123342_() - pos.m_123342_()), (double)(otherPos.m_123343_() - pos.m_123343_()));
                    return Shapes.m_83113_((VoxelShape)finalShape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.f_82695_);
                }).orElse(shape);
            }
            edges.addAll(VoxelOutliner.linesFromVoxelShapeSimplified(shape, pos));
        });
        return edges;
    }

    public static List<Edge> linesFromVoxelShapeSimplified(VoxelShape shape, BlockPos pos) {
        if (shape.m_83281_()) {
            return List.of();
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        shape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 a = new Vec3(minX, minY, minZ).m_82549_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            Vec3 b = new Vec3(maxX, maxY, maxZ).m_82549_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            edges.add(new Edge(a, b));
        });
        if (edges.size() <= 12) {
            return edges;
        }
        return VoxelOutliner.boundsEdgesFromShape(shape, pos);
    }

    private static double f1(Edge e) {
        return switch (e.axis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> e.a().f_82480_;
            case Direction.Axis.Y -> e.a().f_82479_;
            case Direction.Axis.Z -> e.a().f_82479_;
        };
    }

    private static double f2(Edge e) {
        return switch (e.axis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> e.a().f_82481_;
            case Direction.Axis.Y -> e.a().f_82481_;
            case Direction.Axis.Z -> e.a().f_82480_;
        };
    }

    private static boolean isSilhouette(Edge e, double[] b, double eps) {
        double f1 = VoxelOutliner.f1(e);
        double f2 = VoxelOutliner.f2(e);
        return VoxelOutliner.nearly(f1, b[0], eps) || VoxelOutliner.nearly(f1, b[1], eps) || VoxelOutliner.nearly(f2, b[2], eps) || VoxelOutliner.nearly(f2, b[3], eps);
    }

    private static boolean nearly(double a, double b, double eps) {
        return Math.abs(a - b) <= eps;
    }

    public static List<Edge> computeRenderableEdges(Collection<BlockPos> blocks) {
        HashSet<BlockPos> solid = new HashSet<BlockPos>(blocks);
        NormalsAccumulator acc = new NormalsAccumulator();
        for (BlockPos blockPos : solid) {
            int n = blockPos.m_123341_();
            int y = blockPos.m_123342_();
            int z = blockPos.m_123343_();
            block6: for (Direction dir : Direction.values()) {
                if (solid.contains(blockPos.m_121945_(dir))) continue;
                switch (dir.m_122434_()) {
                    case X: {
                        int xf = dir == Direction.EAST ? n + 1 : n;
                        acc.addFaceEdges(dir, new EdgeKey(xf, y, z, xf, y + 1, z), new EdgeKey(xf, y + 1, z, xf, y + 1, z + 1), new EdgeKey(xf, y + 1, z + 1, xf, y, z + 1), new EdgeKey(xf, y, z + 1, xf, y, z));
                        continue block6;
                    }
                    case Y: {
                        int yf = dir == Direction.UP ? y + 1 : y;
                        acc.addFaceEdges(dir, new EdgeKey(n, yf, z, n + 1, yf, z), new EdgeKey(n + 1, yf, z, n + 1, yf, z + 1), new EdgeKey(n + 1, yf, z + 1, n, yf, z + 1), new EdgeKey(n, yf, z + 1, n, yf, z));
                        continue block6;
                    }
                    case Z: {
                        int zf = dir == Direction.SOUTH ? z + 1 : z;
                        acc.addFaceEdges(dir, new EdgeKey(n, y, zf, n + 1, y, zf), new EdgeKey(n + 1, y, zf, n + 1, y + 1, zf), new EdgeKey(n + 1, y + 1, zf, n, y + 1, zf), new EdgeKey(n, y + 1, zf, n, y, zf));
                    }
                }
            }
        }
        List<EdgeInt> edges = new ArrayList<EdgeInt>();
        for (Map.Entry<EdgeKey, EnumMap<Direction, Integer>> entry : acc.edgeToNormals.entrySet()) {
            EnumMap<Direction, Integer> normals = entry.getValue();
            int total = normals.values().stream().mapToInt(i -> i).sum();
            if (normals.size() == 1 && total == 2) continue;
            int edgeMask = VoxelOutliner.maskOf(normals.keySet());
            EdgeKey k = entry.getKey();
            edges.add(new EdgeInt(k.x1(), k.y1(), k.z1(), k.x2(), k.y2(), k.z2(), k.axis(), edgeMask));
        }
        edges = VoxelOutliner.mergeColinearEdges(edges);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(edges.size());
        for (EdgeInt e : edges) {
            Vec3 a = new Vec3((double)e.x1, (double)e.y1, (double)e.z1);
            Vec3 b = new Vec3((double)e.x2, (double)e.y2, (double)e.z2);
            arrayList.add(new Edge(a, b));
        }
        return arrayList;
    }

    private static List<EdgeInt> mergeColinearEdges(List<EdgeInt> edges) {
        record GKey(Direction.Axis axis, int a, int b, int mask) {
        }
        HashMap<GKey, List> groups = new HashMap<GKey, List>();
        for (EdgeInt e2 : edges) {
            switch (e2.axis) {
                case X: {
                    groups.computeIfAbsent(new GKey(Direction.Axis.X, e2.y1, e2.z1, e2.edgeMask), k -> new ArrayList()).add(e2);
                    break;
                }
                case Y: {
                    groups.computeIfAbsent(new GKey(Direction.Axis.Y, e2.x1, e2.z1, e2.edgeMask), k -> new ArrayList()).add(e2);
                    break;
                }
                case Z: {
                    groups.computeIfAbsent(new GKey(Direction.Axis.Z, e2.x1, e2.y1, e2.edgeMask), k -> new ArrayList()).add(e2);
                }
            }
        }
        ArrayList<EdgeInt> merged = new ArrayList<EdgeInt>(edges.size());
        for (Map.Entry ent : groups.entrySet()) {
            List list = (List)ent.getValue();
            if (list.isEmpty()) continue;
            Direction.Axis axis = ((GKey)ent.getKey()).axis();
            int mask = ((GKey)ent.getKey()).mask();
            switch (axis) {
                case X: {
                    EdgeInt e3;
                    int i;
                    list.sort(Comparator.comparingInt(e -> e.x1));
                    int y = ((EdgeInt)list.get((int)0)).y1;
                    int z = ((EdgeInt)list.get((int)0)).z1;
                    int s = ((EdgeInt)list.get((int)0)).x1;
                    int epos = ((EdgeInt)list.get((int)0)).x2;
                    for (i = 1; i < list.size(); ++i) {
                        e3 = (EdgeInt)list.get(i);
                        if (e3.y1 == y && e3.z1 == z && e3.x1 == epos) {
                            epos = e3.x2;
                            continue;
                        }
                        merged.add(new EdgeInt(s, y, z, epos, y, z, Direction.Axis.X, mask));
                        y = e3.y1;
                        z = e3.z1;
                        s = e3.x1;
                        epos = e3.x2;
                    }
                    merged.add(new EdgeInt(s, y, z, epos, y, z, Direction.Axis.X, mask));
                    break;
                }
                case Y: {
                    EdgeInt e3;
                    int i;
                    list.sort(Comparator.comparingInt(e -> e.y1));
                    int x = ((EdgeInt)list.get((int)0)).x1;
                    int z = ((EdgeInt)list.get((int)0)).z1;
                    int s = ((EdgeInt)list.get((int)0)).y1;
                    int epos = ((EdgeInt)list.get((int)0)).y2;
                    for (i = 1; i < list.size(); ++i) {
                        e3 = (EdgeInt)list.get(i);
                        if (e3.x1 == x && e3.z1 == z && e3.y1 == epos) {
                            epos = e3.y2;
                            continue;
                        }
                        merged.add(new EdgeInt(x, s, z, x, epos, z, Direction.Axis.Y, mask));
                        x = e3.x1;
                        z = e3.z1;
                        s = e3.y1;
                        epos = e3.y2;
                    }
                    merged.add(new EdgeInt(x, s, z, x, epos, z, Direction.Axis.Y, mask));
                    break;
                }
                case Z: {
                    EdgeInt e3;
                    int i;
                    list.sort(Comparator.comparingInt(e -> e.z1));
                    int x = ((EdgeInt)list.get((int)0)).x1;
                    int y = ((EdgeInt)list.get((int)0)).y1;
                    int s = ((EdgeInt)list.get((int)0)).z1;
                    int epos = ((EdgeInt)list.get((int)0)).z2;
                    for (i = 1; i < list.size(); ++i) {
                        e3 = (EdgeInt)list.get(i);
                        if (e3.x1 == x && e3.y1 == y && e3.z1 == epos) {
                            epos = e3.z2;
                            continue;
                        }
                        merged.add(new EdgeInt(x, y, s, x, y, epos, Direction.Axis.Z, mask));
                        x = e3.x1;
                        y = e3.y1;
                        s = e3.z1;
                        epos = e3.z2;
                    }
                    merged.add(new EdgeInt(x, y, s, x, y, epos, Direction.Axis.Z, mask));
                }
            }
        }
        return merged;
    }

    private static List<Edge> boundsEdgesFromShape(VoxelShape shape, BlockPos pos) {
        return VoxelOutliner.boxEdges(shape.m_83288_(Direction.Axis.X) + (double)pos.m_123341_(), shape.m_83288_(Direction.Axis.Y) + (double)pos.m_123342_(), shape.m_83288_(Direction.Axis.Z) + (double)pos.m_123343_(), shape.m_83297_(Direction.Axis.X) + (double)pos.m_123341_(), shape.m_83297_(Direction.Axis.Y) + (double)pos.m_123342_(), shape.m_83297_(Direction.Axis.Z) + (double)pos.m_123343_());
    }

    private static List<Edge> boxEdges(double x0, double y0, double z0, double x1, double y1, double z1) {
        if (x1 <= x0 || y1 <= y0 || z1 <= z0) {
            return List.of();
        }
        ArrayList<Edge> out = new ArrayList<Edge>(12);
        out.add(new Edge(new Vec3(x0, y0, z0), new Vec3(x1, y0, z0)));
        out.add(new Edge(new Vec3(x1, y0, z0), new Vec3(x1, y0, z1)));
        out.add(new Edge(new Vec3(x1, y0, z1), new Vec3(x0, y0, z1)));
        out.add(new Edge(new Vec3(x0, y0, z1), new Vec3(x0, y0, z0)));
        out.add(new Edge(new Vec3(x0, y1, z0), new Vec3(x1, y1, z0)));
        out.add(new Edge(new Vec3(x1, y1, z0), new Vec3(x1, y1, z1)));
        out.add(new Edge(new Vec3(x1, y1, z1), new Vec3(x0, y1, z1)));
        out.add(new Edge(new Vec3(x0, y1, z1), new Vec3(x0, y1, z0)));
        out.add(new Edge(new Vec3(x0, y0, z0), new Vec3(x0, y1, z0)));
        out.add(new Edge(new Vec3(x1, y0, z0), new Vec3(x1, y1, z0)));
        out.add(new Edge(new Vec3(x1, y0, z1), new Vec3(x1, y1, z1)));
        out.add(new Edge(new Vec3(x0, y0, z1), new Vec3(x0, y1, z1)));
        return out;
    }

    public static List<Edge> edgesFromAABB(AABB aabb) {
        return VoxelOutliner.boxEdges(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public static final class Edge {
        private final Vec3 a;
        private final Vec3 b;
        private final Direction.Axis axis;
        private final double length;

        public Edge(int x1, int y1, int z1, int x2, int y2, int z2) {
            this(new Vec3((double)x1, (double)y1, (double)z1), new Vec3((double)x2, (double)y2, (double)z2));
        }

        public Edge(Vec3 a, Vec3 b) {
            this.a = a;
            this.b = b;
            this.axis = a.f_82479_ != b.f_82479_ ? Direction.Axis.X : (a.f_82480_ != b.f_82480_ ? Direction.Axis.Y : Direction.Axis.Z);
            this.length = a.m_82554_(b);
        }

        public Vec3 a() {
            return this.a;
        }

        public Vec3 b() {
            return this.b;
        }

        public Direction.Axis axis() {
            return this.axis;
        }

        public double length() {
            return this.length;
        }
    }

    private static final class NormalsAccumulator {
        private final Map<EdgeKey, EnumMap<Direction, Integer>> edgeToNormals = new HashMap<EdgeKey, EnumMap<Direction, Integer>>();

        private NormalsAccumulator() {
        }

        void addFaceEdges(Direction faceNormal, EdgeKey ... keys) {
            for (EdgeKey k : keys) {
                EnumMap m = this.edgeToNormals.computeIfAbsent(k, kk -> new EnumMap(Direction.class));
                m.merge(faceNormal, 1, Integer::sum);
            }
        }
    }

    private record EdgeKey(int x1, int y1, int z1, int x2, int y2, int z2) {
        EdgeKey {
            if (x1 > x2 || x1 == x2 && (y1 > y2 || y1 == y2 && z1 > z2)) {
                int tx = x1;
                int ty = y1;
                int tz = z1;
                x1 = x2;
                y1 = y2;
                z1 = z2;
                x2 = tx;
                y2 = ty;
                z2 = tz;
            }
        }

        Direction.Axis axis() {
            if (this.x1 != this.x2) {
                return Direction.Axis.X;
            }
            if (this.y1 != this.y2) {
                return Direction.Axis.Y;
            }
            if (this.z1 != this.z2) {
                return Direction.Axis.Z;
            }
            throw new IllegalStateException("Non-axis aligned edge");
        }
    }

    private record EdgeInt(int x1, int y1, int z1, int x2, int y2, int z2, Direction.Axis axis, int edgeMask) {
    }
}

