/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ldlib;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.ClientProxy;
import com.lowdragmc.lowdraglib.client.forge.ClientProxyImpl;
import com.lowdragmc.lowdraglib.client.model.custommodel.LDLMetadataSection;
import com.lowdragmc.lowdraglib.client.model.forge.CustomBakedModelImpl;
import com.lowdragmc.lowdraglib.client.model.forge.LDLRendererModel;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientProxyImpl.class})
@ClientOnlyMixin
@RequiresMod(value="ldlib")
public abstract class ClientProxyImplMixin
implements ModernFixClientIntegration {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void registerIntegration(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Redirect(method={"modelBake"}, at=@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;", ordinal=0), remap=false)
    private Set<?> disableLoop(Map<?, ?> map) {
        return Set.of();
    }

    @Override
    public BakedModel onBakedModelLoad(ResourceLocation rl, UnbakedModel rootModel, BakedModel baked, ModelState state, ModelBakery bakery, Function<Material, TextureAtlasSprite> textureGetter) {
        if (baked == null) {
            return null;
        }
        if (rl instanceof ModelResourceLocation && rootModel != null) {
            if (baked instanceof LDLRendererModel) {
                return baked;
            }
            if (baked.m_7521_()) {
                return baked;
            }
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = ClientProxy.WRAPPED_MODELS.getOrDefault((Object)rl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : bakery.m_119341_(dep);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    HashSet textures = new HashSet(ClientProxy.SCRAPED_TEXTURES.get((Object)dep));
                    for (Material tex : textures) {
                        if (LDLMetadataSection.getMetadata((ResourceLocation)LDLMetadataSection.spriteToAbsolute((ResourceLocation)tex.m_119203_())).isMissing()) continue;
                        shouldWrap = true;
                        break;
                    }
                    if (shouldWrap) continue;
                    for (ResourceLocation newDep : model.m_7970_()) {
                        if (!seenModels.add(newDep)) continue;
                        dependencies.push(newDep);
                    }
                }
                catch (Exception e) {
                    LDLib.LOGGER.error("Error loading baked dependency {} for baked {}. Skipping...", new Object[]{dep, rl, e});
                }
            }
            ClientProxy.WRAPPED_MODELS.put((Object)rl, shouldWrap);
            if (shouldWrap) {
                return new CustomBakedModelImpl(baked);
            }
        }
        return baked;
    }
}

