/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.inventory;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.CommonAbstractions;
import fuzs.barteringstation.init.ModRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BarteringStationMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;

    public BarteringStationMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(21), (ContainerData)new SimpleContainerData(2));
    }

    public BarteringStationMenu(int containerId, Inventory inventory, Container container, ContainerData containerData) {
        super((MenuType)ModRegistry.BARTERING_STATION_MENU_TYPE.get(), containerId);
        int i;
        BarteringStationMenu.m_38869_((Container)container, (int)21);
        BarteringStationMenu.m_38886_((ContainerData)containerData, (int)2);
        this.container = container;
        this.data = containerData;
        for (i = 0; i < 6; ++i) {
            this.m_38897_(new Slot(container, i, 11 + i % 2 * 18, 17 + i / 2 * 18){

                public boolean m_5857_(ItemStack stack) {
                    return CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
                }
            });
        }
        for (i = 6; i < 21; ++i) {
            this.m_38897_(new Slot(container, i, 77 + (i - 6) % 5 * 18, 17 + (i - 6) / 5 * 18){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(containerData);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= 6 && index < 21) {
                if (!this.m_38903_(itemstack1, 21, 57, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 21 ? (CommonAbstractions.INSTANCE.isPiglinCurrency(itemstack1) ? !this.m_38903_(itemstack1, 0, 6, false) : (index < 48 ? !this.m_38903_(itemstack1, 48, 57, false) : index < 57 && !this.m_38903_(itemstack1, 21, 48, false))) : !this.m_38903_(itemstack1, 21, 57, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public int getTopArrowProgress() {
        return (((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - this.data.m_6413_(0)) * 2 * 24 / ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
    }

    public int getBottomArrowProgress() {
        return (((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - this.data.m_6413_(0)) * 2 * 24 / ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - 24;
    }

    public float getCooldownProgress() {
        return (float)this.data.m_6413_(0) / (float)((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
    }

    public int getNearbyPiglins() {
        return this.data.m_6413_(1);
    }
}

