/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.core.events;

import com.peeko32213.seafarer.core.events.BrushingEventSound;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BrushingEvent
extends Event {
    private final Level level;
    private final ItemStack item;
    private final Player player;

    public BrushingEvent(Level level, ItemStack item, Player player) {
        this.level = level;
        this.item = item;
        this.player = player;
    }

    public Level getLevel() {
        return this.level;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Player getPlayer() {
        return this.player;
    }

    public HumanoidArm getArm() {
        return this.getPlayer().m_7655_() == InteractionHand.MAIN_HAND ? this.getPlayer().m_5737_() : this.getPlayer().m_5737_().m_20828_();
    }

    public Vec3 getVec() {
        return this.getPlayer().m_20252_(0.0f);
    }

    @Cancelable
    public static class Entity
    extends BrushingEvent {
        private final EntityHitResult entityHitResult;
        private final net.minecraft.world.entity.Entity targetEntity;
        private final BlockPos pos;

        public Entity(Level level, ItemStack item, Player player, EntityHitResult entityHitResult, net.minecraft.world.entity.Entity targetEntity, BlockPos pos) {
            super(level, item, player);
            this.entityHitResult = entityHitResult;
            this.targetEntity = targetEntity;
            this.pos = pos;
        }

        public EntityHitResult getEntityHitResult() {
            return this.entityHitResult;
        }

        public net.minecraft.world.entity.Entity getTargetEntity() {
            return this.targetEntity;
        }

        public SoundEvent getSoundEvent() {
            net.minecraft.world.entity.Entity entity = this.getTargetEntity();
            if (entity instanceof BrushingEventSound) {
                BrushingEventSound event = (BrushingEventSound)entity;
                return event.getBrushingSound();
            }
            return SoundEvents.f_276624_;
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }

    @Cancelable
    public static class Block
    extends BrushingEvent {
        private final BlockHitResult blockHitResult;
        private final BlockPos pos;

        public Block(Level level, ItemStack item, Player player, BlockHitResult blockHitResult, BlockPos pos) {
            super(level, item, player);
            this.blockHitResult = blockHitResult;
            this.pos = pos;
        }

        public BlockHitResult getBlockHitResult() {
            return this.blockHitResult;
        }

        public BlockState getBlockState() {
            return this.getLevel().m_8055_(this.getPos());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public SoundEvent getSoundEvent() {
            net.minecraft.world.level.block.Block block = this.getBlockState().m_60734_();
            if (block instanceof BrushingEventSound) {
                BrushingEventSound event = (BrushingEventSound)block;
                return event.getBrushingSound();
            }
            if (block instanceof BrushableBlock) {
                BrushableBlock brushableblock = (BrushableBlock)block;
                return brushableblock.m_276856_();
            }
            return SoundEvents.f_276624_;
        }
    }
}

