/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer;

import com.peeko32213.seafarer.client.event.ClientEvents;
import com.peeko32213.seafarer.core.registry.SFBlockEntities;
import com.peeko32213.seafarer.core.registry.SFBlocks;
import com.peeko32213.seafarer.core.registry.SFCreativeTabs;
import com.peeko32213.seafarer.core.registry.SFEntities;
import com.peeko32213.seafarer.core.registry.SFEntityPlacement;
import com.peeko32213.seafarer.core.registry.SFFeatures;
import com.peeko32213.seafarer.core.registry.SFItems;
import com.peeko32213.seafarer.core.registry.SFLootModifiers;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="seafarer")
public class SeaFarer {
    public static final String MODID = "seafarer";
    private static int packetsRegistered;
    public static final Logger LOGGER;

    public SeaFarer() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(ClientEvents::init));
        SFBlocks.BLOCKS.register(modEventBus);
        SFItems.ITEMS.register(modEventBus);
        SFCreativeTabs.DEF_REG.register(modEventBus);
        SFEntities.ENTITIES.register(modEventBus);
        SFFeatures.FEATURES.register(modEventBus);
        SFBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        SFLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SFEntityPlacement.entityPlacement();
            SeaFarer.addToFlowerPot(SFBlocks.COASTAL_LAVENDER, SFBlocks.POTTED_COASTAL_LAVENDER);
            SeaFarer.addToFlowerPot(SFBlocks.COASTAL_WILDFLOWER, SFBlocks.POTTED_COASTAL_WILDFLOWER);
            SeaFarer.addToFlowerPot(SFBlocks.SEA_THRIFT, SFBlocks.POTTED_SEA_THRIFT);
            SeaFarer.addToFlowerPot(SFBlocks.SEA_HOLLY, SFBlocks.POTTED_SEA_HOLLY);
            SeaFarer.addToComposter(SFBlocks.COASTAL_LAVENDER, 0.7f);
            SeaFarer.addToComposter(SFBlocks.COASTAL_WILDFLOWER, 0.3f);
            SeaFarer.addToComposter(SFBlocks.SEA_THRIFT, 0.5f);
            SeaFarer.addToComposter(SFBlocks.SEA_HOLLY, 0.6f);
        });
    }

    public static void addToFlowerPot(RegistryObject<Block> plantBlockLoc, Supplier<? extends Block> pottedPlantBlock) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(plantBlockLoc.getId(), pottedPlantBlock);
    }

    public static void addToComposter(RegistryObject<Block> item, float amountOfCompost) {
        ComposterBlock.f_51914_.put((Object)((Block)item.get()).m_5456_(), amountOfCompost);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

