/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.base;

import earth.terrarium.handcrafted.common.blocks.base.SittableBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.ModularSeatProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class ModularSeatBlock
extends HorizontalDirectionalBlock
implements SittableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<ModularSeatProperty> SHAPE = EnumProperty.m_61587_((String)"shape", ModularSeatProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ModularSeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)ModularSeatProperty.SINGLE))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, f_54117_, WATERLOGGED});
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        ModularSeatProperty couchShape = (ModularSeatProperty)((Object)state.m_61143_(SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                ModularSeatProperty shape = switch (couchShape) {
                    case ModularSeatProperty.OUTER_LEFT -> ModularSeatProperty.OUTER_RIGHT;
                    case ModularSeatProperty.OUTER_RIGHT -> ModularSeatProperty.OUTER_LEFT;
                    case ModularSeatProperty.INNER_LEFT -> ModularSeatProperty.INNER_RIGHT;
                    case ModularSeatProperty.INNER_RIGHT -> ModularSeatProperty.INNER_LEFT;
                    default -> couchShape;
                };
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)shape));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                ModularSeatProperty shape = switch (couchShape) {
                    case ModularSeatProperty.OUTER_LEFT -> ModularSeatProperty.OUTER_RIGHT;
                    case ModularSeatProperty.OUTER_RIGHT -> ModularSeatProperty.OUTER_LEFT;
                    case ModularSeatProperty.INNER_LEFT -> ModularSeatProperty.INNER_LEFT;
                    case ModularSeatProperty.INNER_RIGHT -> ModularSeatProperty.INNER_RIGHT;
                    default -> couchShape;
                };
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)shape));
            }
        }
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.sitOn(level, pos, player, (Direction)state.m_61143_((Property)f_54117_))) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME_PARTIAL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)context.m_43725_(), pos)));
    }

    public boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState other = level.m_8055_(pos.m_121945_(face));
        return !other.m_60713_((Block)this) || other.m_61143_((Property)f_54117_) != state.m_61143_((Property)f_54117_);
    }

    public ModularSeatProperty getShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction dir;
        Direction dir2;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockState state1 = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (state1.m_60713_((Block)this) && (dir2 = (Direction)state1.m_61143_((Property)f_54117_)).m_122434_() != ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() && this.canTakeShape(state, level, pos, dir2)) {
            return dir2 == direction.m_122428_() ? ModularSeatProperty.OUTER_LEFT : ModularSeatProperty.OUTER_RIGHT;
        }
        BlockState state2 = level.m_8055_(pos.m_121945_(direction));
        if (state2.m_60713_((Block)this) && (dir = (Direction)state2.m_61143_((Property)f_54117_)).m_122434_() != ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() && this.canTakeShape(state, level, pos, dir.m_122424_())) {
            return dir == direction.m_122428_() ? ModularSeatProperty.INNER_LEFT : ModularSeatProperty.INNER_RIGHT;
        }
        BlockState state3 = level.m_8055_(pos.m_121945_(direction.m_122427_().m_122424_()));
        BlockState state4 = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        if (!state3.m_60713_((Block)this) && !state4.m_60713_((Block)this)) {
            return ModularSeatProperty.SINGLE;
        }
        if (!state3.m_60713_((Block)this)) {
            return ModularSeatProperty.RIGHT;
        }
        if (!state4.m_60713_((Block)this)) {
            return ModularSeatProperty.LEFT;
        }
        return ModularSeatProperty.MIDDLE;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

