/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.mixin;

import com.teamabnormals.blueprint.core.other.tags.BlueprintEntityTypeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PointedDripstoneBlock.class})
public abstract class PointedDripstoneBlockMixin {
    @Shadow
    private static boolean m_154203_(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Shadow
    private static BlockPos m_154130_(BlockState state, LevelAccessor level, BlockPos pos, int num, boolean bool) {
        return null;
    }

    @Shadow
    private static BlockPos m_154076_(Level level, BlockPos pos, Fluid fluid) {
        return null;
    }

    @Shadow
    private static boolean m_154240_(BlockState state) {
        return false;
    }

    @Shadow
    private static Optional<BlockPos> m_154066_(Level level, BlockPos pos, BlockState state, int num) {
        return Optional.empty();
    }

    @Shadow
    private static Fluid m_154052_(Level level, Fluid fluid) {
        return null;
    }

    @Inject(at={@At(value="RETURN")}, method={"canFillCauldron"}, cancellable=true)
    private static void canFillCauldron(Fluid fluid, CallbackInfoReturnable<Boolean> cir) {
        if (fluid == ForgeMod.MILK.get()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getFluidAboveStalactite"}, cancellable=true)
    private static void getFluidAboveStalactite(Level level, BlockPos pos, BlockState state, CallbackInfoReturnable<Optional<PointedDripstoneBlock.FluidInfo>> cir) {
        Optional<List> entities = PointedDripstoneBlockMixin.m_154066_(level, pos, state, 11).map(newPos -> level.m_142425_(EntityTypeTest.m_156916_(Entity.class), new AABB(newPos.m_7494_()), entity -> entity.m_6095_().m_204039_(BlueprintEntityTypeTags.MILKABLE)));
        if (PointedDripstoneBlockMixin.m_154240_(state) && entities.isPresent() && !entities.get().isEmpty()) {
            cir.setReturnValue(Optional.of(new PointedDripstoneBlock.FluidInfo(pos, (Fluid)ForgeMod.MILK.get(), Blocks.f_50016_.m_49966_())));
        }
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", shift=At.Shift.BY, by=-10), index=14, method={"spawnDripParticle(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)V"})
    private static ParticleOptions spawnDripParticle(ParticleOptions options, Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Fluid dripFluid = PointedDripstoneBlockMixin.m_154052_(level, fluid);
        if (dripFluid != null && dripFluid.m_205067_(Tags.Fluids.MILK)) {
            options = (ParticleOptions)NeapolitanParticleTypes.DRIPPING_DRIPSTONE_MILK.get();
        }
        return options;
    }

    @Inject(at={@At(value="HEAD")}, method={"maybeTransferFluid"})
    private static void maybeFillCauldron(BlockState state, ServerLevel level, BlockPos pos, float chance, CallbackInfo ci) {
        BlockPos cauldronPos;
        BlockPos tipPos;
        Fluid fluid;
        if (!(chance > 0.17578125f && chance > 0.05859375f || !PointedDripstoneBlockMixin.m_154203_(state, (LevelReader)level, pos) || (fluid = PointedDripstoneBlock.m_221849_((ServerLevel)level, (BlockPos)pos)) != ForgeMod.MILK.get() || chance >= 0.1171875f || (tipPos = PointedDripstoneBlockMixin.m_154130_(state, (LevelAccessor)level, pos, 11, false)) == null || (cauldronPos = PointedDripstoneBlockMixin.m_154076_((Level)level, tipPos, fluid)) == null)) {
            level.m_46796_(1504, tipPos, 0);
            int i = tipPos.m_123342_() - cauldronPos.m_123342_();
            int j = 50 + i;
            BlockState blockstate = level.m_8055_(cauldronPos);
            level.m_186460_(cauldronPos, blockstate.m_60734_(), j);
        }
    }
}

