/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.neapolitan.common.block.MintBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MintPondFeature
extends Feature<NoneFeatureConfiguration> {
    public MintPondFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        BlockPos blockpos = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
        List directions = Direction.Plane.HORIZONTAL.m_122557_().toList();
        boolean spruce = false;
        int i = 0;
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        ArrayList<Object> waterPositions = new ArrayList<Object>();
        ArrayList<BlockPos> mintPositions = new ArrayList<BlockPos>();
        position.m_122154_((Vec3i)blockpos, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
        if (MintPondFeature.isSafeSpotForWater(level, (BlockPos)position)) {
            waterPositions.add(position);
            for (Direction direction : directions) {
                BlockPos offsetPos = position.m_121945_(direction);
                if (!MintPondFeature.isSafeSpotForWater(level, offsetPos)) continue;
                waterPositions.add(offsetPos);
                BlockPos cornerPos = offsetPos.m_121945_(direction.m_122427_());
                if (MintPondFeature.isSafeSpotForWater(level, cornerPos) && random.m_188503_(3) != 0) {
                    waterPositions.add(cornerPos);
                }
                for (Direction direction2 : directions) {
                    BlockPos offsetPos2 = offsetPos.m_121945_(direction);
                    if (!MintPondFeature.isSafeSpotForWater(level, offsetPos2) || random.m_188503_(3) != 0) continue;
                    waterPositions.add(offsetPos2);
                    BlockPos cornerPos2 = offsetPos2.m_121945_(direction2.m_122427_());
                    if (!MintPondFeature.isSafeSpotForWater(level, cornerPos2) || random.m_188503_(4) == 0) continue;
                    waterPositions.add(cornerPos);
                }
            }
            for (BlockPos blockPos : waterPositions) {
                for (Direction direction : directions) {
                    mintPositions.add(blockPos.m_7494_().m_121945_(direction));
                }
            }
            for (BlockPos blockPos : waterPositions) {
                MintPondFeature.placeWater(level, blockPos);
            }
            for (BlockPos blockPos : mintPositions) {
                if (!spruce && random.m_188503_(3) == 0) {
                    ((ConfiguredFeature)((Registry)level.m_9598_().m_6632_(Registries.f_256911_).get()).m_6246_(TreeFeatures.f_195127_)).m_224953_(level, context.m_159775_(), random, blockPos);
                    spruce = true;
                    continue;
                }
                MintPondFeature.placeMint(level, blockPos, random);
            }
            ++i;
        }
        return i > 0;
    }

    private static void placeMint(WorldGenLevel world, BlockPos pos, RandomSource random) {
        if (world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && random.m_188503_(4) == 0) {
            world.m_7731_(pos, (BlockState)((BlockState)((Block)NeapolitanBlocks.MINT.get()).m_49966_().m_61124_((Property)MintBlock.AGE, (Comparable)Integer.valueOf(4))).m_61124_((Property)MintBlock.SPROUTS, (Comparable)Integer.valueOf(1 + random.m_188503_(3) + random.m_188503_(2))), 2);
        }
    }

    private static void placeWater(WorldGenLevel world, BlockPos pos) {
        world.m_7731_(pos, Blocks.f_49990_.m_49966_(), 2);
        if (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) || world.m_8055_(pos.m_7495_()).m_60795_()) {
            world.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
    }

    private static boolean isSafeSpotForWater(WorldGenLevel level, BlockPos pos) {
        return MintPondFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos) && MintPondFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_122024_()) && MintPondFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_122029_()) && MintPondFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_122012_()) && MintPondFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_122019_());
    }
}

