/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ChiseledBookshelfProcessor
extends StructureProcessor {
    public static final Codec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256762_).optionalFieldOf("allowed_book_enchantments").forGetter(config -> config.allowedBookEnchantments), (App)IntProvider.m_146545_((int)0, (int)6).optionalFieldOf("number_of_books").forGetter(config -> config.numberOfBooks), (App)IntProvider.m_146545_((int)0, (int)6).optionalFieldOf("number_of_enchanted").forGetter(config -> config.numberOfEnchanted)).apply((Applicative)instance, instance.stable(ChiseledBookshelfProcessor::new)));
    public final Optional<HolderSet<Enchantment>> allowedBookEnchantments;
    public final Optional<IntProvider> numberOfBooks;
    public final Optional<IntProvider> numberOfEnchanted;

    public ChiseledBookshelfProcessor(Optional<HolderSet<Enchantment>> allowedBookEnchantments, Optional<IntProvider> numberOfBooks, Optional<IntProvider> numberOfEnchanted) {
        this.allowedBookEnchantments = allowedBookEnchantments;
        this.numberOfBooks = numberOfBooks;
        this.numberOfEnchanted = numberOfEnchanted;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (structureBlockInfoWorld.f_74676_().m_60713_(Blocks.f_244299_) && this.numberOfBooks.isPresent() && this.numberOfEnchanted.isPresent() && this.allowedBookEnchantments.isPresent() && this.allowedBookEnchantments.get().m_203632_() > 0) {
            NonNullList items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            RandomSource randomSource = settings.m_230326_(structureBlockInfoWorld.f_74675_());
            int maxNumberOfBooks = this.numberOfBooks.get().m_214085_(randomSource);
            int maxNumberOfEnchanted = this.numberOfEnchanted.get().m_214085_(randomSource);
            int currentNumOfEnchanted = 0;
            BlockState chiseledBookshelfState = structureBlockInfoWorld.f_74676_();
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(0), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(1), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(2), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(3), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(4), (Comparable)Boolean.valueOf(false));
            chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(5), (Comparable)Boolean.valueOf(false));
            for (int bookNum = 0; bookNum < maxNumberOfBooks; ++bookNum) {
                Optional enchantment;
                ItemStack book = Items.f_42517_.m_7968_();
                if (currentNumOfEnchanted < maxNumberOfEnchanted && (enchantment = this.allowedBookEnchantments.get().m_213653_(randomSource)).isPresent()) {
                    book = Items.f_42690_.m_7968_();
                    book.m_41663_((Enchantment)((Holder)enchantment.get()).m_203334_(), randomSource.m_216332_(((Enchantment)((Holder)enchantment.get()).m_203334_()).m_44702_(), ((Enchantment)((Holder)enchantment.get()).m_203334_()).m_6586_()));
                    ++currentNumOfEnchanted;
                }
                int index = randomSource.m_188503_(6);
                while (!((ItemStack)items.get(index)).m_41619_()) {
                    index = randomSource.m_188503_(6);
                }
                items.set(index, (Object)book);
                chiseledBookshelfState = (BlockState)chiseledBookshelfState.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(index), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag tag = structureBlockInfoWorld.f_74677_() == null ? new CompoundTag() : structureBlockInfoWorld.f_74677_().m_6426_();
            ContainerHelper.m_18976_((CompoundTag)tag, (NonNullList)items, (boolean)true);
            tag.m_128473_("last_interacted_slot");
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_(), chiseledBookshelfState, tag);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.CHISELED_BOOKSHELF_PROCESSOR.get();
    }
}

