/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.BiomeBasedLayerConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class LayeredBlockSurface
extends Feature<BiomeBasedLayerConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public LayeredBlockSurface(Codec<BiomeBasedLayerConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<BiomeBasedLayerConfig> context) {
        this.setSeed(context.m_159774_().m_7328_());
        BlockPos.MutableBlockPos mutableBlockPos = context.m_159777_().m_122032_();
        BlockPos.MutableBlockPos mutableBlockPosForChunk = new BlockPos.MutableBlockPos();
        ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
        Biome targetBiome = (Biome)((Registry)context.m_159774_().m_9598_().m_6632_(Registries.f_256952_).get()).m_7745_(((BiomeBasedLayerConfig)context.m_159778_()).biomeRL);
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.m_159774_());
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                ChunkPos currentChunkPos = new ChunkPos(chunkPos.f_45578_ + xOffset, chunkPos.f_45579_ + zOffset);
                mutableBlockPosForChunk.m_122190_((Vec3i)currentChunkPos.m_45615_());
                ChunkAccess cachedChunk = context.m_159774_().m_46865_(currentChunkPos.m_45615_());
                if (xOffset != 0 && zOffset != 0 && cachedChunk.m_183278_(0).m_204433_(0, 0, 0).m_203334_() == targetBiome) continue;
                this.fillChunkWithPollen(context, bulkSectionAccess, cachedChunk, currentChunkPos.m_45615_(), targetBiome);
            }
        }
        return true;
    }

    private void fillChunkWithPollen(FeaturePlaceContext<BiomeBasedLayerConfig> context, UnsafeBulkSectionAccess bulkSectionAccess, ChunkAccess cachedChunk, BlockPos startPos, Biome targetBiome) {
        int configHeight = ((BiomeBasedLayerConfig)context.m_159778_()).height;
        BlockState configBlockState = ((BiomeBasedLayerConfig)context.m_159778_()).state;
        Optional<BlockState> configRareBlockState = ((BiomeBasedLayerConfig)context.m_159778_()).rareState;
        BlockPos.MutableBlockPos mutable = context.m_159777_().m_122032_();
        BlockState previousBlockState = Blocks.f_50016_.m_49966_();
        RandomSource random = context.m_225041_();
        int maxY = context.m_159775_().m_6331_() + context.m_159775_().m_142062_() - 1;
        for (int xOffset = 0; xOffset <= 15; ++xOffset) {
            for (int zOffset = 0; zOffset <= 15; ++zOffset) {
                mutable.m_122178_(startPos.m_123341_() + xOffset, maxY, startPos.m_123343_() + zOffset);
                if (targetBiome != context.m_159774_().m_204166_((BlockPos)mutable).m_203334_()) continue;
                while (mutable.m_123342_() >= context.m_159775_().m_6337_() - 1) {
                    BlockState currentBlockState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!(currentBlockState.m_60795_() || !currentBlockState.m_60819_().m_76178_() || previousBlockState.m_60734_() != Blocks.f_50016_ || currentBlockState.m_60713_(configBlockState.m_60734_()) || configRareBlockState.isPresent() && currentBlockState.m_60713_(configRareBlockState.get().m_60734_()))) {
                        if (!currentBlockState.m_60783_((BlockGetter)context.m_159774_(), (BlockPos)mutable, Direction.UP)) {
                            previousBlockState = currentBlockState;
                            mutable.m_122173_(Direction.DOWN);
                            continue;
                        }
                        for (int height = 1; height <= configHeight && mutable.m_123342_() + height < maxY; ++height) {
                            BlockEntity blockEntity;
                            BlockState finalBlockState;
                            BlockPos finalPosition = mutable.m_6630_(height);
                            if (height > 1 && !(finalBlockState = bulkSectionAccess.getBlockState(finalPosition)).m_60795_()) break;
                            int layerHeight = 8;
                            if (height == configHeight) {
                                float xzScale = 0.035f;
                                float yScale = 0.015f;
                                double noiseVal = Math.abs(noiseGen.noise3_Classic((float)mutable.m_123341_() * xzScale, (float)mutable.m_123342_() * yScale + (float)height, (float)mutable.m_123343_() * xzScale));
                                layerHeight = Math.max(1, (int)((noiseVal * 0.63 + 0.4) * 8.0));
                                layerHeight = Math.min(8, layerHeight);
                            }
                            BlockState blockToPlace = configBlockState;
                            if ((height < configHeight || layerHeight == 8) && configRareBlockState.isPresent() && random.m_188501_() < ((BiomeBasedLayerConfig)context.m_159778_()).rareStateChance) {
                                blockToPlace = configRareBlockState.get();
                            }
                            if (blockToPlace.m_61138_((Property)BlockStateProperties.f_61417_)) {
                                bulkSectionAccess.setBlockState(finalPosition, (BlockState)blockToPlace.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layerHeight)), false);
                                context.m_159774_().m_186460_(finalPosition, blockToPlace.m_60734_(), 0);
                                continue;
                            }
                            bulkSectionAccess.setBlockState(finalPosition, blockToPlace, false);
                            if (!blockToPlace.m_155947_() || (blockEntity = ((EntityBlock)blockToPlace.m_60734_()).m_142194_(finalPosition, blockToPlace)) == null) continue;
                            if (blockEntity instanceof BrushableBlockEntity) {
                                BrushableBlockEntity brushableBlock = (BrushableBlockEntity)blockEntity;
                                if (((BiomeBasedLayerConfig)context.m_159778_()).suspiciousBlockLoot.isPresent()) {
                                    brushableBlock.m_277049_(((BiomeBasedLayerConfig)context.m_159778_()).suspiciousBlockLoot.get(), random.m_188505_());
                                }
                            }
                            cachedChunk.m_142169_(blockEntity);
                        }
                    }
                    previousBlockState = currentBlockState;
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        }
    }
}

