/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class HoneycombCaves
extends Feature<NoneFeatureConfiguration> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;
    protected static OpenSimplex2F noiseGen2;
    private static final int[][] hexagon7;
    private static final int[][] hexagon6;
    private static final int[][] hexagon5;
    private static final int[][] hexagon4;
    private static final int[][] hexagon3;
    private static final int[][] hexagon2;
    private static final int[][] hexagon1;
    private static final int[][][] hexagonArray;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            noiseGen2 = new OpenSimplex2F(seed + 1000L);
            this.seed = seed;
        }
    }

    public HoneycombCaves(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        this.setSeed(level.m_7328_());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)context.m_159777_());
        int disallowedBottomRange = Integer.MAX_VALUE;
        int disallowedTopRange = Integer.MIN_VALUE;
        WorldGenLevel worldGenLevel = context.m_159774_();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.m_9598_().m_6632_(Registries.f_256944_).get();
            StructureManager structureManager = ((WorldGenRegionAccessor)worldGenRegion).bumblezone$getStructureManager();
            ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
            List structureStarts = structureManager.m_220477_(chunkPos, struct -> structureRegistry.m_246971_((ResourceKey)structureRegistry.m_7854_(struct).get()).m_203656_(BzTags.NO_CAVES));
            for (StructureStart structureStart : structureStarts) {
                disallowedBottomRange = Math.min(disallowedBottomRange, structureStart.m_73601_().m_162396_());
                disallowedTopRange = Math.max(disallowedTopRange, structureStart.m_73601_().m_162400_());
            }
        }
        int orgX = context.m_159777_().m_123341_();
        int orgY = context.m_159777_().m_123342_();
        int orgZ = context.m_159777_().m_123343_();
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.m_159774_());
        for (int y = 15; y < 241; ++y) {
            if (y > disallowedBottomRange && y < disallowedTopRange) continue;
            mutableBlockPos.m_122178_(orgX, orgY, orgZ).m_122184_(0, y, 0);
            if (bulkSectionAccess.getSection((BlockPos)mutableBlockPos).m_188008_()) {
                y += 16 - y % 16;
                continue;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    mutableBlockPos.m_122178_(orgX, orgY, orgZ).m_122184_(x, y, z);
                    double noise1 = noiseGen.noise3_Classic((double)mutableBlockPos.m_123341_() * 0.019, (double)mutableBlockPos.m_123343_() * 0.019, (double)mutableBlockPos.m_123342_() * 0.038);
                    if (noise1 >= 0.037 || noise1 <= -0.037) {
                        z = this.zSkipping(z, noise1);
                        continue;
                    }
                    double noise2 = noiseGen2.noise3_Classic((double)mutableBlockPos.m_123341_() * 0.019, (double)mutableBlockPos.m_123343_() * 0.019, (double)mutableBlockPos.m_123342_() * 0.038);
                    double finalNoise = noise1 * noise1 + noise2 * noise2;
                    if (finalNoise < (double)0.0014f) {
                        HoneycombCaves.hexagon(level, bulkSectionAccess, context.m_159775_(), (BlockPos)mutableBlockPos, context.m_225041_(), noise1);
                        continue;
                    }
                    z = this.zSkipping(z, finalNoise);
                }
            }
        }
        return true;
    }

    private int zSkipping(int z, double noise1) {
        if (noise1 >= 0.8) {
            z += 7;
        } else if (noise1 >= 0.7) {
            z += 6;
        } else if (noise1 >= 0.6) {
            z += 5;
        } else if (noise1 >= 0.5) {
            z += 4;
        } else if (noise1 >= 0.4) {
            z += 3;
        } else if (noise1 >= 0.3) {
            z += 2;
        } else if (noise1 >= 0.2) {
            ++z;
        }
        return z;
    }

    private static void hexagon(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, ChunkGenerator generator, BlockPos position, RandomSource random, double noise) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int index = (int)((noise * 0.5 + 0.5) * 7.0);
        BlockPos.MutableBlockPos tempMutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 14; ++x) {
            for (int z = 0; z < 11; ++z) {
                int posResult = hexagonArray[index][z][x];
                if (posResult == 0) continue;
                mutableBlockPos.m_122190_((Vec3i)position).m_122184_(x - 7, 0, z - 5);
                BlockState blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
                mutableBlockPos.m_122190_((Vec3i)position).m_122184_(0, x - 7, z - 5);
                blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
                mutableBlockPos.m_122190_((Vec3i)position).m_122184_(z - 5, x - 7, 0);
                blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
            }
        }
    }

    private static void carveAtBlock(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, ChunkGenerator generator, RandomSource random, BlockPos blockPos, BlockPos.MutableBlockPos mutable, BlockState blockState, int posResult) {
        if (blockState.m_60815_() && !blockState.m_247087_() && !blockState.m_204336_(BzTags.FORCE_CAVE_TO_NOT_CARVE)) {
            boolean isNextToAir = HoneycombCaves.shouldCloseOff(bulkSectionAccess, blockPos, mutable);
            if (blockPos.m_123342_() >= generator.m_6337_() && isNextToAir) {
                return;
            }
            if (posResult == 2) {
                if (blockPos.m_123342_() < generator.m_6337_()) {
                    if (isNextToAir) {
                        bulkSectionAccess.setBlockState(blockPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), false);
                    } else {
                        bulkSectionAccess.setBlockState(blockPos, BzFluids.SUGAR_WATER_BLOCK.get().m_49966_(), false);
                    }
                    if (blockState.m_155947_()) {
                        world.m_46865_(blockPos).m_8114_(blockPos);
                    }
                } else {
                    BlockPos abovePos;
                    BlockState aboveState;
                    bulkSectionAccess.setBlockState(blockPos, Blocks.f_50627_.m_49966_(), false);
                    if (blockState.m_155947_()) {
                        world.m_46865_(blockPos).m_8114_(blockPos);
                    }
                    if (!(aboveState = bulkSectionAccess.getBlockState(abovePos = blockPos.m_7494_())).m_60795_() && !aboveState.m_60838_((BlockGetter)world, abovePos)) {
                        bulkSectionAccess.setBlockState(blockPos, Blocks.f_50627_.m_49966_(), false);
                        if (aboveState.m_60734_() instanceof DoublePlantBlock && aboveState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER) {
                            bulkSectionAccess.setBlockState(abovePos, Blocks.f_50627_.m_49966_(), false);
                        }
                    }
                }
            } else if (posResult == 1) {
                if (random.m_188503_(3) == 0) {
                    bulkSectionAccess.setBlockState(blockPos, Blocks.f_50720_.m_49966_(), false);
                } else {
                    bulkSectionAccess.setBlockState(blockPos, BzBlocks.FILLED_POROUS_HONEYCOMB.get().m_49966_(), false);
                }
                if (blockState.m_155947_()) {
                    world.m_46865_(blockPos).m_8114_(blockPos);
                }
            }
        }
    }

    private static boolean shouldCloseOff(UnsafeBulkSectionAccess bulkSectionAccess, BlockPos position, BlockPos.MutableBlockPos mutableBlockPos) {
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122190_((Vec3i)position).m_122173_(direction);
            BlockState blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
            if (!blockState.m_60713_(Blocks.f_50016_)) continue;
            return true;
        }
        return false;
    }

    static {
        hexagon7 = new int[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
        hexagon6 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon5 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon4 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon3 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon2 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon1 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagonArray = new int[][][]{hexagon1, hexagon2, hexagon3, hexagon4, hexagon5, hexagon6, hexagon7};
    }
}

