/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseGeneratorSettingsAccessor;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeInfluencedNoiseSampler;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BiomeRegistryHolder;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.BzBiomeSource;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.NoVerticalBlendBiomeManager;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.NoiseChunkExtension;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.apache.commons.lang3.mutable.MutableObject;

public class BzChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final Holder<NoiseGeneratorSettings> settings;
    private final Aquifer.FluidPicker globalFluidPicker;

    public BzChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> supplier) {
        super(biomeSource, supplier);
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)supplier.m_203334_();
        this.defaultBlock = noiseGeneratorSettings.f_64440_();
        this.defaultFluid = noiseGeneratorSettings.f_64441_();
        NoiseRouter noiseRouter = noiseGeneratorSettings.f_209353_();
        Climate.Sampler sampler = new Climate.Sampler(noiseRouter.f_209384_(), noiseRouter.f_224392_(), noiseRouter.f_209386_(), noiseRouter.f_209387_(), noiseRouter.f_209388_(), noiseRouter.f_209389_(), noiseGeneratorSettings.f_224370_());
        ((NoiseGeneratorSettingsAccessor)noiseGeneratorSettings).bumblezone$setNoiseRouter(noiseRouter.m_224412_(densityFunction -> {
            if (densityFunction instanceof BiomeNoise) {
                return new BiomeNoise(() -> ((BzChunkGenerator)this).m_62218_(), () -> sampler);
            }
            return densityFunction;
        }));
        this.settings = supplier;
        int seaLevel = noiseGeneratorSettings.f_64444_();
        Aquifer.FluidStatus sea = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.f_64441_());
        this.globalFluidPicker = (x, y, z) -> sea;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    protected void m_224291_(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseChunk noiseChunk = chunkAccess.m_223012_(chunkAccess1 -> this.m_224256_((ChunkAccess)chunkAccess1, structureManager, blender, randomState));
        Climate.Sampler sampler = ((NoiseChunkExtension)noiseChunk).the_bumblezone$getCachedClimateSampler();
        BiomeResolver biomeresolver = this.getBiomeResolver((BiomeResolver)((NoiseChunkExtension)noiseChunk).the_bumblezone$getBiomeSource());
        chunkAccess.m_183442_(biomeresolver, sampler);
    }

    private BiomeResolver getBiomeResolver(BiomeResolver biomeResolver) {
        return (x, y, z, biomeHolder) -> biomeResolver.m_203407_(x, 0, z, biomeHolder);
    }

    protected NoiseChunk m_224256_(ChunkAccess chunkAccess, StructureManager structureManager, Blender blender, RandomState randomState) {
        NoiseChunk noiseChunk = super.m_224256_(chunkAccess, structureManager, blender, randomState);
        this.postInitNoiseChunk(randomState, noiseChunk);
        return noiseChunk;
    }

    private void postInitNoiseChunk(RandomState randomState, NoiseChunk noiseChunk) {
        BiomeSource biomeSource = this.f_62137_;
        if (biomeSource instanceof BzBiomeSource) {
            BzBiomeSource bzBiomeSource = (BzBiomeSource)biomeSource;
            ((NoiseChunkExtension)noiseChunk).the_bumblezone$setBiomeSource(new BzBiomeSource(bzBiomeSource));
        } else {
            ((NoiseChunkExtension)noiseChunk).the_bumblezone$setBiomeSource(this.f_62137_);
        }
        ((NoiseChunkExtension)noiseChunk).the_bumblezone$setCachedClimateSampler(((NoiseChunkAccessor)noiseChunk).bumblezone$callCachedClimateSampler(randomState.m_224578_(), ((NoiseGeneratorSettings)this.settings.m_203334_()).f_224370_()));
    }

    public int m_214096_(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.m_224239_(levelHeightAccessor, randomState, x, z, null, types.m_64299_()).orElse(levelHeightAccessor.m_141937_());
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        MutableObject mutableobject = new MutableObject();
        this.m_224239_(levelHeightAccessor, randomState, x, z, (MutableObject<NoiseColumn>)mutableobject, null);
        return (NoiseColumn)mutableobject.getValue();
    }

    public void m_213600_(List<String> strings, RandomState randomState, BlockPos blockPos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = randomState.m_224578_();
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        double d0 = noiserouter.f_209389_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        strings.add("NoiseRouter T: " + decimalformat.format(noiserouter.f_209384_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.f_224392_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.f_209386_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.f_209387_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.f_209388_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.m_224435_((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.f_209390_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.f_209391_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    protected OptionalInt m_224239_(LevelHeightAccessor levelHeightAccessor, RandomState randomState, int x, int z, MutableObject<NoiseColumn> mutableObject, Predicate<BlockState> blockStatePredicate) {
        NoiseSettings noisesettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().m_224530_(levelHeightAccessor);
        int i = noisesettings.m_189212_();
        int j = noisesettings.f_158688_();
        int k = Mth.m_14042_((int)j, (int)i);
        int l = Mth.m_14042_((int)noisesettings.f_64508_(), (int)i);
        if (l > 0) {
            BlockState[] ablockstate;
            if (mutableObject == null) {
                ablockstate = null;
            } else {
                ablockstate = new BlockState[noisesettings.f_64508_()];
                mutableObject.setValue((Object)new NoiseColumn(j, ablockstate));
            }
            int i1 = noisesettings.m_189213_();
            int j1 = Math.floorDiv(x, i1);
            int k1 = Math.floorDiv(z, i1);
            int l1 = Math.floorMod(x, i1);
            int i2 = Math.floorMod(z, i1);
            int j2 = j1 * i1;
            int k2 = k1 * i1;
            double d0 = (double)l1 / (double)i1;
            double d1 = (double)i2 / (double)i1;
            NoiseChunk noiseChunk = new NoiseChunk(1, randomState, j2, k2, noisesettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, (NoiseGeneratorSettings)this.settings.m_203334_(), this.globalFluidPicker, Blender.m_190153_());
            this.postInitNoiseChunk(randomState, noiseChunk);
            noiseChunk.m_188791_();
            noiseChunk.m_188749_(0);
            for (int l2 = l - 1; l2 >= 0; --l2) {
                noiseChunk.m_188810_(l2, 0);
                for (int i3 = i - 1; i3 >= 0; --i3) {
                    BlockState blockstate1;
                    int j3 = (k + l2) * i + i3;
                    double d2 = (double)i3 / (double)i;
                    noiseChunk.m_209191_(j3, d2);
                    noiseChunk.m_209230_(x, d0);
                    noiseChunk.m_209241_(z, d1);
                    BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).bumblezone$callGetInterpolatedState();
                    BlockState blockState = blockstate1 = blockstate == null ? this.defaultBlock : blockstate;
                    if (ablockstate != null) {
                        int k3 = l2 * i + i3;
                        ablockstate[k3] = blockstate1;
                    }
                    if (blockStatePredicate == null || !blockStatePredicate.test(blockstate1)) continue;
                    noiseChunk.m_209248_();
                    return OptionalInt.of(j3 + 1);
                }
            }
            noiseChunk.m_209248_();
        }
        return OptionalInt.empty();
    }

    public void m_214194_(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess) {
        BiomeManager.NoiseBiomeSource noiseBiomeSource;
        BiomeManager biomeManager;
        WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)worldGenRegion);
        BiomeSource biomeSource = this.f_62137_;
        if (biomeSource instanceof BiomeManager.NoiseBiomeSource) {
            BiomeManager.NoiseBiomeSource noiseBiomeSource2 = (BiomeManager.NoiseBiomeSource)biomeSource;
            biomeManager = new BiomeManager(noiseBiomeSource2, worldGenRegion.m_7328_());
        } else {
            biomeManager = worldGenRegion.m_7062_();
        }
        Blender blender = Blender.m_190202_((WorldGenRegion)worldGenRegion);
        NoiseChunk noisechunk = chunkAccess.m_223012_(noiseChunk -> this.m_224256_((ChunkAccess)noiseChunk, structureManager, blender, randomState));
        BiomeSource biomeSource2 = ((NoiseChunkExtension)noisechunk).the_bumblezone$getBiomeSource();
        biomeManager = new NoVerticalBlendBiomeManager(biomeManager, biomeSource2 instanceof BiomeManager.NoiseBiomeSource ? (noiseBiomeSource = (BiomeManager.NoiseBiomeSource)biomeSource2) : null);
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        randomState.m_224580_().m_224648_(randomState, biomeManager, (Registry)worldGenRegion.m_9598_().m_6632_(Registries.f_256952_).get(), noisegeneratorsettings.f_209354_(), worldgenerationcontext, chunkAccess, noisechunk, noisegeneratorsettings.f_188871_());
    }

    public void m_224261_(ChunkAccess chunkAccess, WorldGenerationContext worldGenerationContext, RandomState randomState, StructureManager structureManager, BiomeManager biomeManager, Registry<Biome> biomeRegistry, Blender blender) {
        NoiseChunk noisechunk = chunkAccess.m_223012_(noiseChunk -> this.m_224256_((ChunkAccess)noiseChunk, structureManager, blender, randomState));
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        randomState.m_224580_().m_224648_(randomState, biomeManager, biomeRegistry, noisegeneratorsettings.f_209354_(), worldGenerationContext, chunkAccess, noisechunk, noisegeneratorsettings.f_188871_());
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long seed, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    protected ChunkAccess m_224284_(Blender blender, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, int x, int z) {
        NoiseChunk noiseChunk = chunkAccess.m_223012_(chunkAccess1 -> this.m_224256_((ChunkAccess)chunkAccess1, structureManager, blender, randomState));
        Heightmap heightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = chunkAccess.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Aquifer aquifer = noiseChunk.m_188817_();
        noiseChunk.m_188791_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().m_189213_();
        int l = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().m_189212_();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noiseChunk.m_188749_(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                int bottomBlockY = chunkAccess.m_151559_() - 1;
                LevelChunkSection levelchunksection = chunkAccess.m_183278_(chunkAccess.m_151559_() - 1);
                for (int i2 = z - 1; i2 >= 0; --i2) {
                    noiseChunk.m_188810_(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (x + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = chunkAccess.m_151564_(k2);
                        if (bottomBlockY != i3) {
                            levelchunksection = chunkAccess.m_183278_(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noiseChunk.m_209191_(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noiseChunk.m_209230_(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noiseChunk.m_209241_(j4, d2);
                                BlockState blockstate = ((NoiseChunkAccessor)noiseChunk).bumblezone$callGetInterpolatedState();
                                if (blockstate == null) {
                                    blockstate = this.defaultBlock;
                                }
                                if (blockstate == Blocks.f_50016_.m_49966_()) continue;
                                levelchunksection.m_62991_(l3, l2, k4, blockstate, false);
                                heightmap.m_64249_(l3, k2, k4, blockstate);
                                heightmap1.m_64249_(l3, k2, k4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                chunkAccess.m_8113_((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noiseChunk.m_188804_();
        }
        noiseChunk.m_209248_();
        return chunkAccess;
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    public Holder<NoiseGeneratorSettings> m_224341_() {
        return this.settings;
    }

    public void m_6929_(WorldGenRegion region) {
        if (!((NoiseGeneratorSettings)this.settings.m_203334_()).f_64445_()) {
            ChunkPos chunkpos = region.m_143488_();
            Holder holder = region.m_204166_(chunkpos.m_45615_().m_175288_(region.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
            worldgenrandom.m_64690_(region.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            BzChunkGenerator.spawnNonBeeMobsForChunkGeneration((ServerLevelAccessor)region, (Holder<Biome>)holder, chunkpos, (RandomSource)worldgenrandom);
        }
    }

    public static void spawnNonBeeMobsForChunkGeneration(ServerLevelAccessor serverLevelAccessor, Holder<Biome> biomeHolder, ChunkPos chunkPos, RandomSource randomSource) {
        MobSpawnSettings mobspawnsettings = ((Biome)biomeHolder.m_203334_()).m_47518_();
        WeightedRandomList weightedrandomlist = mobspawnsettings.m_151798_(MobCategory.CREATURE);
        if (BzGeneralConfigs.specialBeeSpawning) {
            weightedrandomlist = WeightedRandomList.m_146328_(weightedrandomlist.m_146338_().stream().filter(e -> e.f_48404_ != EntityType.f_20550_).toList());
        }
        if (!weightedrandomlist.m_146337_()) {
            int minX = chunkPos.m_45604_();
            int minZ = chunkPos.m_45605_();
            int seaLevel = ((ServerChunkCache)serverLevelAccessor.m_7726_()).m_8481_().m_6337_();
            while ((double)randomSource.m_188501_() < (double)mobspawnsettings.m_48344_() * 0.5) {
                Optional optional = weightedrandomlist.m_216829_(randomSource);
                if (!optional.isPresent()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = (MobSpawnSettings.SpawnerData)optional.get();
                int groupCount = mobspawnsettings$spawnerdata.f_48405_ + randomSource.m_188503_(1 + mobspawnsettings$spawnerdata.f_48406_ - mobspawnsettings$spawnerdata.f_48405_);
                SpawnGroupData spawngroupdata = null;
                int x = minX + randomSource.m_188503_(16);
                int z = minZ + randomSource.m_188503_(16);
                int tempX = x;
                int tempZ = z;
                for (int currentGroupCount = 0; currentGroupCount < groupCount; ++currentGroupCount) {
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, randomSource.m_188503_(250 - seaLevel) + seaLevel, z);
                    if (serverLevelAccessor.m_6042_().f_63856_()) {
                        do {
                            mutableBlockPos.m_122173_(Direction.DOWN);
                        } while (!serverLevelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60795_());
                        do {
                            mutableBlockPos.m_122173_(Direction.DOWN);
                        } while (serverLevelAccessor.m_8055_((BlockPos)mutableBlockPos).m_60795_() && mutableBlockPos.m_123342_() > serverLevelAccessor.m_141937_());
                    }
                    if (mobspawnsettings$spawnerdata.f_48404_.m_20654_()) {
                        float mobWidth = mobspawnsettings$spawnerdata.f_48404_.m_20678_();
                        double finalX = Mth.m_14008_((double)((double)x + 0.5), (double)((double)minX + (double)mobWidth + 0.5), (double)((double)minX + 15.5 - (double)mobWidth));
                        double finalZ = Mth.m_14008_((double)((double)z + 0.5), (double)((double)minZ + (double)mobWidth + 0.5), (double)((double)minZ + 15.5 - (double)mobWidth));
                        if (!serverLevelAccessor.m_6857_().m_156093_(finalX, finalZ) || mutableBlockPos.m_123342_() < serverLevelAccessor.m_141937_() || mutableBlockPos.m_123342_() >= serverLevelAccessor.m_151558_()) continue;
                        Entity entity = null;
                        try {
                            entity = mobspawnsettings$spawnerdata.f_48404_.m_20615_((Level)serverLevelAccessor.m_6018_());
                            entity.m_7678_(finalX, (double)mutableBlockPos.m_123342_(), finalZ, randomSource.m_188501_() * 360.0f, 0.0f);
                            if (entity instanceof Mob) {
                                Mob mob = (Mob)entity;
                                PlatformHooks.finalizeSpawn(mob, serverLevelAccessor, null, MobSpawnType.CHUNK_GENERATION, null);
                                if (mob.m_6914_((LevelReader)serverLevelAccessor)) {
                                    spawngroupdata = mob.m_6518_(serverLevelAccessor, serverLevelAccessor.m_6436_(mob.m_20183_()), MobSpawnType.CHUNK_GENERATION, spawngroupdata, null);
                                    mob.m_6027_(mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_());
                                    serverLevelAccessor.m_47205_((Entity)mob);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Bumblezone.LOGGER.error("Failed to create mob: {}", (Object)entity);
                            exception.addSuppressed(new RuntimeException("Failed to create mob: " + String.valueOf(entity)));
                            throw exception;
                        }
                    }
                    x += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    z += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    while (x < minX || x >= minX + 16 || z < minZ || z >= minZ + 16) {
                        x = tempX + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                        z = tempZ + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                    }
                }
            }
        }
    }

    public record BiomeNoise(Supplier<BiomeSource> biomeSource, Supplier<Climate.Sampler> sampler) implements DensityFunction.SimpleFunction
    {
        public static final KeyDispatchDataCodec<BiomeNoise> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)new BiomeNoise(null, null)));

        public double m_207386_(DensityFunction.FunctionContext functionContext) {
            if (this.biomeSource == null || this.sampler == null) {
                throw new IllegalStateException("Attempting to sample uninitialized BzChunkGenerator$BiomeNoise");
            }
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.m_207115_(), functionContext.m_207113_(), this.sampler.get(), this.biomeSource.get(), BiomeRegistryHolder.BIOME_REGISTRY);
        }

        public double m_207402_() {
            return -10.0;
        }

        public double m_207401_() {
            return 10.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return CODEC;
        }
    }
}

