/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.TradeHintParticleSpawnPacketHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;

public record TradeHintParticleSpawnPacket(int queenId, ResourceLocation wantItem, List<ResourceLocation> rewardItems) implements Packet<TradeHintParticleSpawnPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "trade_hint_particle_spawn");
    static final Handler HANDLER = new Handler();

    public static void sendToClient(Entity queen, Item wantItem, List<Item> rewardItems) {
        ResourceLocation wantItemRl = BuiltInRegistries.f_257033_.m_7981_((Object)wantItem);
        ArrayList<ResourceLocation> rewardItemRls = new ArrayList<ResourceLocation>(rewardItems.size());
        for (Item item : rewardItems) {
            rewardItemRls.add(BuiltInRegistries.f_257033_.m_7981_((Object)item));
        }
        MessageHandler.DEFAULT_CHANNEL.sendToPlayersInLevel(new TradeHintParticleSpawnPacket(queen.m_19879_(), wantItemRl, rewardItemRls), queen.m_9236_());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<TradeHintParticleSpawnPacket> getHandler() {
        return HANDLER;
    }

    private static final class Handler
    implements PacketHandler<TradeHintParticleSpawnPacket> {
        private Handler() {
        }

        @Override
        public void encode(TradeHintParticleSpawnPacket message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.queenId());
            buffer.m_130085_(message.wantItem());
            buffer.writeInt(message.rewardItems().size());
            for (ResourceLocation rewardItem : message.rewardItems()) {
                buffer.m_130085_(rewardItem);
            }
        }

        @Override
        public TradeHintParticleSpawnPacket decode(FriendlyByteBuf buffer) {
            int queenId = buffer.readInt();
            ResourceLocation wantItem = buffer.m_130281_();
            int sizeOfRewards = buffer.readInt();
            ArrayList<ResourceLocation> rewardItems = new ArrayList<ResourceLocation>(sizeOfRewards);
            for (int i = 0; i < sizeOfRewards; ++i) {
                rewardItems.add(buffer.m_130281_());
            }
            return new TradeHintParticleSpawnPacket(queenId, wantItem, rewardItems);
        }

        @Override
        public PacketContext handle(TradeHintParticleSpawnPacket message) {
            return (player, level) -> {
                Entity queen = level.m_6815_(message.queenId());
                if (queen != null) {
                    TradeHintParticleSpawnPacketHandler.handle(message, queen, level);
                }
            };
        }
    }
}

