/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.entities;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.FilledPorousHoneycomb;
import com.telepathicgrunt.the_bumblezone.blocks.PorousHoneycomb;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.CalmingEssence;
import com.telepathicgrunt.the_bumblezone.loot.EntityLootDropInterface;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1200)
public abstract class EntityMixin
implements EntityLootDropInterface {
    @Unique
    public boolean thebumblezone_performedEntityDrops = false;

    @Override
    public boolean thebumblezone_hasPerformedEntityDrops() {
        return this.thebumblezone_performedEntityDrops;
    }

    @Override
    public void thebumblezone_performedEntityDrops() {
        this.thebumblezone_performedEntityDrops = true;
    }

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract Level m_9236_();

    @ModifyVariable(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"), require=0)
    private double bumblezone$beeRidingOffset(double yOffset, Entity entity) {
        return StinglessBeeHelmet.beeRidingOffset(yOffset, (Entity)this, entity);
    }

    @ModifyReturnValue(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="RETURN")}, require=0)
    private boolean bumblezone$applyMissingWaterPhysicsForSugarWaterFluid(boolean appliedFluidPush) {
        if (!appliedFluidPush) {
            return PlatformHooks.getFluidHeight((Entity)this, BzTags.SUGAR_WATER_FLUID, BzFluids.SUGAR_WATER_FLUID_TYPE.get()) > 0.0;
        }
        return true;
    }

    @Inject(method={"checkInsideBlocks()V"}, at={@At(value="HEAD")})
    private void bumblezone$pollinatedBeeBlockFilling(CallbackInfo ci) {
        Bee bee;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Bee && ((bee = (Bee)entityMixin).m_27856_() || bee.m_21223_() < bee.m_21233_())) {
            AABB aABB = this.m_20191_();
            BlockPos minBlockPos = BlockPos.m_274561_((double)(aABB.f_82288_ - 1.0E-7), (double)(aABB.f_82289_ - 1.0E-7), (double)(aABB.f_82290_ - 1.0E-7));
            BlockPos maxBlockPos = BlockPos.m_274561_((double)(aABB.f_82291_ + 1.0E-7), (double)(aABB.f_82292_ + 1.0E-7), (double)(aABB.f_82293_ + 1.0E-7));
            BlockPos minThreshold = BlockPos.m_274561_((double)(aABB.f_82288_ + 1.0E-7), (double)(aABB.f_82289_ + 1.0E-7), (double)(aABB.f_82290_ + 1.0E-7));
            BlockPos maxThreshold = BlockPos.m_274561_((double)(aABB.f_82291_ - 1.0E-7), (double)(aABB.f_82292_ - 1.0E-7), (double)(aABB.f_82293_ - 1.0E-7));
            if (this.m_9236_().m_46832_(minThreshold, maxThreshold)) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = minBlockPos.m_123341_(); x <= maxBlockPos.m_123341_(); ++x) {
                    for (int y = minBlockPos.m_123342_(); y <= maxBlockPos.m_123342_(); ++y) {
                        for (int z = minBlockPos.m_123343_(); z <= maxBlockPos.m_123343_(); ++z) {
                            int sideCheckPassed = 0;
                            if (x < minThreshold.m_123341_()) {
                                ++sideCheckPassed;
                            }
                            if (y < minThreshold.m_123342_()) {
                                ++sideCheckPassed;
                            }
                            if (z < minThreshold.m_123343_()) {
                                ++sideCheckPassed;
                            }
                            if (x > maxThreshold.m_123341_()) {
                                ++sideCheckPassed;
                            }
                            if (y > maxThreshold.m_123342_()) {
                                ++sideCheckPassed;
                            }
                            if (z > maxThreshold.m_123343_()) {
                                ++sideCheckPassed;
                            }
                            if (sideCheckPassed != 1) continue;
                            mutableBlockPos.m_122178_(x, y, z);
                            BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
                            if (blockState.m_60713_(BzBlocks.POROUS_HONEYCOMB.get())) {
                                PorousHoneycomb.beeHoneyFill(blockState, this.m_9236_(), (BlockPos)mutableBlockPos, (Entity)this);
                                continue;
                            }
                            if (blockState.m_60713_(BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
                                FilledPorousHoneycomb.beeHoneyTake(blockState, this.m_9236_(), (BlockPos)mutableBlockPos, (Entity)this);
                                continue;
                            }
                            if (!blockState.m_60713_(BzBlocks.EMPTY_HONEYCOMB_BROOD.get())) continue;
                            EmptyHoneycombBrood.beeHoneyFill(blockState, this.m_9236_(), (BlockPos)mutableBlockPos, (Entity)this);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void bumblezone$preventAngerableAtPlayer2(Entity comparer, CallbackInfoReturnable<Boolean> cir) {
        Entity current = (Entity)this;
        if (current instanceof Mob || comparer instanceof Mob) {
            Player player;
            Player player2;
            if (current instanceof Player && CalmingEssence.IsCalmingEssenceActive(player2 = (Player)current)) {
                if (!comparer.m_6095_().m_204039_(BzTags.CALMING_ALLOW_ANGER_THROUGH)) {
                    cir.setReturnValue((Object)false);
                }
            } else if (comparer instanceof Player && CalmingEssence.IsCalmingEssenceActive(player = (Player)comparer) && !current.m_6095_().m_204039_(BzTags.CALMING_ALLOW_ANGER_THROUGH)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

