/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.FoxAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class KnowingEssence
extends AbilityEssenceItem {
    private static final String STRUCTURE_LIST = "inStructures";
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.knowingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.knowingEssenceAbilityUse;
    private static final int RED = 0xF90000;
    private static final int ORANGE = 0xFF8800;
    private static final int YELLOW = 0xFFF600;
    private static final int GREEN = 3931904;
    private static final int CYAN = 57564;
    private static final int PURPLE = 13238501;
    private static final int WHITE = 0xFFFCFC;
    private static final int NO_HIGHLIGHT = -1;

    public KnowingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 15737343;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_knowing_description_1").m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_knowing_description_2").m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void rechargeAbilitySlowly(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(stack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            int lastChargeTime = KnowingEssence.getLastAbilityChargeTimestamp(stack);
            if (lastChargeTime == 0 || serverPlayer.f_19797_ < lastChargeTime) {
                KnowingEssence.setLastAbilityChargeTimestamp(stack, serverPlayer.f_19797_);
            } else {
                int timeFromLastCharge = serverPlayer.f_19797_ - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % chargeTimeIncrement == 0) {
                    this.setAbilityUseRemaining(stack, abilityUseRemaining + 1);
                    KnowingEssence.setLastAbilityChargeTimestamp(stack, serverPlayer.f_19797_);
                }
            }
        }
    }

    @Override
    public void rechargeAbilityEntirely(ItemStack stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    @Override
    public void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        if (KnowingEssence.getIsActive(stack)) {
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 5L == 0L) {
                KnowingEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_());
            }
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 20L == 0L) {
                this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                if (BzGeneralConfigs.knowingEssenceStructureNameServer) {
                    StructureManager structureManager = ((ServerLevel)level).m_215010_();
                    List structureStarts = structureManager.m_220477_(new ChunkPos(serverPlayer.m_20183_()), s -> true);
                    ArrayList<Structure> structures = new ArrayList<Structure>();
                    Registry structureRegistry = (Registry)level.m_9598_().m_6632_(Registries.f_256944_).get();
                    for (StructureStart structureStart : structureStarts) {
                        if (!structureStart.m_73601_().m_71051_((Vec3i)serverPlayer.m_20183_()) || GeneralUtils.isInTag(structureRegistry, BzTags.KNOWING_PREVENT_DISPLAYING_NAME, structureStart.m_226861_())) continue;
                        structures.add(structureStart.m_226861_());
                    }
                    CompoundTag tag = stack.m_41784_();
                    if (!structures.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int structureCount = 0;
                        for (Structure structure : structures) {
                            if (structureCount > 0) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append(structureRegistry.m_7981_((Object)structure));
                            ++structureCount;
                        }
                        tag.m_128359_(STRUCTURE_LIST, stringBuilder.toString());
                    } else {
                        tag.m_128473_(STRUCTURE_LIST);
                    }
                } else {
                    stack.m_41784_().m_128473_(STRUCTURE_LIST);
                }
            }
        }
    }

    public static String GetAllStructure(ItemStack stack) {
        return stack.m_41784_().m_128461_(STRUCTURE_LIST);
    }

    public static boolean IsKnowingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.m_21206_();
            return offHandItem.m_150930_(BzItems.ESSENCE_KNOWING.get()) && KnowingEssence.getIsActive(offHandItem);
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(Entity entity, Player player) {
        return KnowingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(Entity entity, Player player) {
        Fox fox;
        OwnableEntity ownableEntity;
        EntityType entityType = entity.m_6095_();
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_PREVENT_HIGHLIGHTING)) {
            return -1;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_WHITE_HIGHLIGHT)) {
            return 0xFFFCFC;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_PURPLE_HIGHLIGHT)) {
            return 13238501;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_CYAN_HIGHLIGHT)) {
            return 57564;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_GREEN_HIGHLIGHT)) {
            return 3931904;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_YELLOW_HIGHLIGHT)) {
            return 0xFFF600;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_ORANGE_HIGHLIGHT)) {
            return 0xFF8800;
        }
        if (entityType.m_204039_(BzTags.KNOWING_ENTITY_FORCED_RED_HIGHLIGHT)) {
            return 0xF90000;
        }
        if (entityType.m_204039_(BzTags.BOSSES)) {
            if (BzClientConfigs.knowingEssenceHighlightBosses) {
                return 13238501;
            }
        } else if (entity instanceof Enemy) {
            if (BzClientConfigs.knowingEssenceHighlightMonsters) {
                return 0xF90000;
            }
        } else if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).m_21805_() != null && ownableEntity.m_21805_().equals(player.m_20148_())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof Fox && ((FoxAccessor)(fox = (Fox)entity)).bumblezone$callTrusts(player.m_20148_())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof LivingEntity) {
            if (BzClientConfigs.knowingEssenceHighlightLivingEntities) {
                return 0xFF8800;
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            if (itemStack.m_41791_() == Rarity.COMMON) {
                if (BzClientConfigs.knowingEssenceHighlightCommonItems) {
                    return 0xFFFCFC;
                }
            } else if (itemStack.m_41791_() == Rarity.UNCOMMON) {
                if (BzClientConfigs.knowingEssenceHighlightUncommonItems) {
                    return 0xFFF600;
                }
            } else if (itemStack.m_41791_() == Rarity.RARE) {
                if (BzClientConfigs.knowingEssenceHighlightRareItems) {
                    return 57564;
                }
            } else if (itemStack.m_41791_() == Rarity.EPIC && BzClientConfigs.knowingEssenceHighlightEpicItems) {
                return 13238501;
            }
        }
        return -1;
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123809_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 1, random.m_188583_() * 0.1, random.m_188583_() * 0.1 + 0.1, random.m_188583_() * 0.1, (double)random.m_188501_() * 0.3 + (double)0.1f);
    }
}

