/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.CooldownInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.ItemCooldownsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityEssenceItem
extends Item
implements ItemExtension {
    private static final String IS_IN_INVENTORY_TAG = "isInInventory";
    private static final String ACTIVE_TAG = "isActive";
    private static final String LOCKED_TAG = "isLocked";
    private static final String COOLDOWN_TIME_TAG = "cooldownTime";
    private static final String FORCED_COOLDOWN_TAG = "forcedCooldown";
    private static final String LAST_ABILITY_CHARGE_TIMESTAMP_TAG = "lastChargeTime";
    private static final String ABILITY_USE_REMAINING_TAG = "abilityUseRemaining";
    private final Supplier<Integer> cooldownTickLength;
    private final Supplier<Integer> abilityUseAmount;

    public AbilityEssenceItem(Item.Properties properties, Supplier<Integer> cooldownTickLength, Supplier<Integer> abilityUseAmount) {
        super(properties);
        this.cooldownTickLength = cooldownTickLength;
        this.abilityUseAmount = abilityUseAmount;
    }

    public abstract int getColor();

    public int getCooldownTickLength() {
        return this.cooldownTickLength.get();
    }

    public static void setLastAbilityChargeTimestamp(ItemStack stack, int gametime) {
        stack.m_41784_().m_128405_(LAST_ABILITY_CHARGE_TIMESTAMP_TAG, gametime);
    }

    public static int getLastAbilityChargeTimestamp(ItemStack stack) {
        return stack.m_41784_().m_128451_(LAST_ABILITY_CHARGE_TIMESTAMP_TAG);
    }

    public static void setIsActive(ItemStack stack, boolean isActive) {
        stack.m_41784_().m_128379_(ACTIVE_TAG, isActive);
    }

    public static boolean getIsActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVE_TAG);
    }

    public static void setIsInInventory(ItemStack stack, boolean isInInventory) {
        stack.m_41784_().m_128379_(IS_IN_INVENTORY_TAG, isInInventory);
    }

    public static boolean getIsInInventory(ItemStack stack) {
        return stack.m_41784_().m_128471_(IS_IN_INVENTORY_TAG);
    }

    public static void setIsLocked(ItemStack stack, boolean isLocked) {
        stack.m_41784_().m_128379_(LOCKED_TAG, isLocked);
    }

    public static boolean getIsLocked(ItemStack stack) {
        return stack.m_41784_().m_128471_(LOCKED_TAG);
    }

    public static void setForcedCooldown(ItemStack stack, boolean forcedCooldown) {
        stack.m_41784_().m_128379_(FORCED_COOLDOWN_TAG, forcedCooldown);
    }

    public static boolean getForcedCooldown(ItemStack stack) {
        return stack.m_41784_().m_128471_(FORCED_COOLDOWN_TAG);
    }

    public static void setCooldownTime(ItemStack stack, int cooldownTime) {
        stack.m_41784_().m_128405_(COOLDOWN_TIME_TAG, cooldownTime);
    }

    public static int getCooldownTime(ItemStack stack) {
        return stack.m_41784_().m_128451_(COOLDOWN_TIME_TAG);
    }

    public void incrementCooldownTime(ItemStack stack) {
        if (AbilityEssenceItem.getForcedCooldown(stack)) {
            int currentCooldownTime = AbilityEssenceItem.getCooldownTime(stack);
            if (currentCooldownTime < this.cooldownTickLength.get()) {
                AbilityEssenceItem.setCooldownTime(stack, currentCooldownTime + 1);
            } else {
                AbilityEssenceItem.setCooldownTime(stack, 0);
                AbilityEssenceItem.setForcedCooldown(stack, false);
                this.rechargeAbilityEntirely(stack);
            }
        }
    }

    public void setDepleted(ItemStack stack, ServerPlayer serverPlayer, boolean vanillaItemCooldown) {
        AbilityEssenceItem.setForcedCooldown(stack, true);
        AbilityEssenceItem.setCooldownTime(stack, 0);
        AbilityEssenceItem.setIsActive(stack, false);
        if (vanillaItemCooldown) {
            serverPlayer.m_36335_().m_41524_((Item)this, this.getCooldownTickLength());
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        if (stack.m_204117_(BzTags.ABILITY_ESSENCE_ITEMS) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!AbilityEssenceItem.getIsInInventory(stack)) {
                AbilityEssenceItem.setIsInInventory(stack, true);
            }
            if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                AbilityEssenceItem.setIsActive(stack, false);
                AbilityEssenceItem.setIsLocked(stack, true);
                return;
            }
            if (AbilityEssenceItem.getIsLocked(stack)) {
                AbilityEssenceItem.setIsLocked(stack, false);
            }
            if (AbilityEssenceItem.getForcedCooldown(stack)) {
                if (!serverPlayer.m_36335_().m_41519_(stack.m_41720_())) {
                    serverPlayer.m_36335_().m_41524_(stack.m_41720_(), this.getCooldownTickLength() - AbilityEssenceItem.getCooldownTime(stack));
                }
                this.incrementCooldownTime(stack);
            } else if (serverPlayer.m_36335_().m_41519_(stack.m_41720_())) {
                ItemCooldowns.CooldownInstance cooldownInstance = ((ItemCooldownsAccessor)serverPlayer.m_36335_()).bumblezone$getCooldowns().get(stack.m_41720_());
                int cooldownTime = ((ItemCooldownsAccessor)serverPlayer.m_36335_()).bumblezone$getTickCount() - ((CooldownInstanceAccessor)cooldownInstance).bumblezone$getStartTime();
                if (cooldownTime > 5) {
                    AbilityEssenceItem.setForcedCooldown(stack, true);
                    AbilityEssenceItem.setCooldownTime(stack, cooldownTime);
                    AbilityEssenceItem.setIsActive(stack, false);
                }
            } else if (serverPlayer.m_21206_() == stack) {
                if (!AbilityEssenceItem.getIsActive(stack)) {
                    AbilityEssenceItem.setIsActive(stack, true);
                }
                this.applyAbilityEffects(stack, level, serverPlayer);
            } else {
                this.rechargeAbilitySlowly(stack, level, serverPlayer);
                if (AbilityEssenceItem.getIsActive(stack)) {
                    AbilityEssenceItem.setIsActive(stack, false);
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (AbilityEssenceItem.getIsLocked(stack)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_locked").m_130940_(ChatFormatting.DARK_RED));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_locked_description_1").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_locked_description_2").m_130940_(ChatFormatting.GRAY));
        } else if (AbilityEssenceItem.getIsActive(stack)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_active").m_130940_(ChatFormatting.RED));
            components.add((Component)Component.m_237110_((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(stack), this.getMaxAbilityUseAmount()}).m_130940_(ChatFormatting.YELLOW));
            components.add((Component)Component.m_237119_());
            this.addDescriptionComponents(components);
        } else if (AbilityEssenceItem.getForcedCooldown(stack)) {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_depleted").m_130940_(ChatFormatting.DARK_RED));
            components.add((Component)Component.m_237110_((String)"item.the_bumblezone.essence_cooldown", (Object[])new Object[]{GeneralUtils.formatTickDurationNoMilliseconds(this.getCooldownTickLength() - AbilityEssenceItem.getCooldownTime(stack), 20.0f)}).m_130940_(ChatFormatting.DARK_RED));
            components.add((Component)Component.m_237119_());
            this.addDescriptionComponents(components);
        } else {
            components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_ready").m_130940_(ChatFormatting.GREEN));
            components.add((Component)Component.m_237110_((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(stack), this.getMaxAbilityUseAmount()}).m_130940_(ChatFormatting.YELLOW));
            components.add((Component)Component.m_237119_());
            this.addDescriptionComponents(components);
        }
    }

    abstract void addDescriptionComponents(List<Component> var1);

    abstract void applyAbilityEffects(ItemStack var1, Level var2, ServerPlayer var3);

    public int getAbilityUseRemaining(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(ABILITY_USE_REMAINING_TAG)) {
            this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
            return this.getMaxAbilityUseAmount();
        }
        return stack.m_41784_().m_128451_(ABILITY_USE_REMAINING_TAG);
    }

    public int getMaxAbilityUseAmount() {
        return this.abilityUseAmount.get();
    }

    public void setAbilityUseRemaining(ItemStack stack, int abilityUseRemaining) {
        stack.m_41784_().m_128405_(ABILITY_USE_REMAINING_TAG, abilityUseRemaining);
    }

    public void rechargeAbilityEntirely(ItemStack stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    public void rechargeAbilitySlowly(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(stack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            int lastChargeTime = AbilityEssenceItem.getLastAbilityChargeTimestamp(stack);
            if (lastChargeTime == 0 || serverPlayer.f_19797_ < lastChargeTime) {
                AbilityEssenceItem.setLastAbilityChargeTimestamp(stack, serverPlayer.f_19797_);
            } else {
                int timeFromLastCharge = serverPlayer.f_19797_ - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % chargeTimeIncrement == 0) {
                    this.setAbilityUseRemaining(stack, abilityUseRemaining + 1);
                    AbilityEssenceItem.setLastAbilityChargeTimestamp(stack, serverPlayer.f_19797_);
                }
            }
        }
    }

    public void decrementAbilityUseRemaining(ItemStack stack, ServerPlayer serverPlayer, int decreaseAmount) {
        this.decrementAbilityUseRemaining(stack, serverPlayer, decreaseAmount, false);
    }

    public void decrementAbilityUseRemaining(ItemStack stack, ServerPlayer serverPlayer, int decreaseAmount, boolean vanillaCooldown) {
        if (serverPlayer.m_7500_() || serverPlayer.m_5833_()) {
            return;
        }
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, vanillaCooldown);
        }
    }

    @Override
    public EquipmentSlot bz$getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public boolean m_142522_(ItemStack itemStack) {
        int remainingUse = this.getAbilityUseRemaining(itemStack);
        return remainingUse != 0 && this.getMaxAbilityUseAmount() != remainingUse;
    }

    public int m_142158_(ItemStack itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        return Math.round(remainingUse / maxAmount * 13.0f);
    }

    public int m_142159_(ItemStack itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        float redValue = Math.max(0.0f, remainingUse / maxAmount);
        return Mth.m_14169_((float)(redValue / 3.0f), (float)1.0f, (float)1.0f);
    }
}

