/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.VariantBeeEntity;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemAttackBlockEvent;
import com.telepathicgrunt.the_bumblezone.menus.BuzzingBriefcaseMenuProvider;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BuzzingBriefcase
extends Item {
    public static final String TAG_BEES = "BeesStored";
    public static final String TAG_VARANT_BEES = "VariantBeesStored";
    public static final int MAX_NUMBER_OF_BEES = 14;

    public BuzzingBriefcase(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_6144_()) {
            player.m_5893_((MenuProvider)new BuzzingBriefcaseMenuProvider(stack));
            player.m_36220_(BzStats.INTERACT_WITH_BUZZING_BRIEFCASE_RL.get());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public static InteractionResult onLeftClickBlock(PlayerItemAttackBlockEvent event) {
        Player player = event.user();
        ItemStack briefcaseItem = player.m_21120_(event.hand());
        if (event.hand() != InteractionHand.MAIN_HAND || !briefcaseItem.m_150930_(BzItems.BUZZING_BRIEFCASE.get()) || player.m_36335_().m_41519_(briefcaseItem.m_41720_())) {
            return null;
        }
        if (player.m_9236_().m_5776_()) {
            int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
            return numberOfBees > 0 ? InteractionResult.SUCCESS : null;
        }
        List<Entity> releasedBees = BuzzingBriefcase.dumpBees(player, player.m_6047_() ? -1 : 0, false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!releasedBees.isEmpty()) {
                BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.trigger(serverPlayer);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)briefcaseItem.m_41720_()));
                serverPlayer.m_36335_().m_41524_(briefcaseItem.m_41720_(), 10);
                return InteractionResult.SUCCESS;
            }
        }
        return null;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (player.m_36335_().m_41519_(stack.m_41720_())) {
                return false;
            }
            boolean isVictimBeelike = BeeAggression.isBeelikeEntity((Entity)victim);
            List<Entity> releasedBees = BuzzingBriefcase.dumpBees(player, player.m_6047_() ? -1 : 0, false);
            for (Entity entity : releasedBees) {
                if (!(entity instanceof NeutralMob)) continue;
                NeutralMob neutralMob = (NeutralMob)entity;
                if (isVictimBeelike) continue;
                neutralMob.m_6710_(victim);
                neutralMob.m_7870_(400);
                neutralMob.m_6925_(victim.m_20148_());
            }
            if (!isVictimBeelike && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!releasedBees.isEmpty()) {
                    BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.trigger(serverPlayer);
                    serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    serverPlayer.m_36335_().m_41524_(stack.m_41720_(), 10);
                }
            }
        }
        return true;
    }

    public InteractionResult m_6880_(ItemStack beeCannon, Player player, LivingEntity entity, InteractionHand playerHand) {
        Bee bee;
        if (!(entity instanceof Bee) || (bee = (Bee)entity).m_6095_().m_204039_(BzTags.BUZZING_BRIEFCASE_DISALLOWED_BEE) || entity.m_21224_()) {
            return InteractionResult.PASS;
        }
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack briefcaseItem = player.m_21120_(playerHand);
        if (player.m_36335_().m_41519_(briefcaseItem.m_41720_())) {
            return InteractionResult.PASS;
        }
        boolean addedBee = BuzzingBriefcase.tryAddBee(briefcaseItem, (Entity)entity);
        if (addedBee) {
            ServerPlayer serverPlayer;
            player.m_36220_(BzStats.BUZZING_BRIEFCASE_BEE_CAPTURE_RL.get());
            player.m_36246_(Stats.f_12982_.m_12902_((Object)briefcaseItem.m_41720_()));
            player.m_21011_(playerHand, true);
            if (player instanceof ServerPlayer && BuzzingBriefcase.getBeesStored((serverPlayer = (ServerPlayer)player).m_9236_(), briefcaseItem, false).size() == 14) {
                BzCriterias.BUZZING_BRIEFCASE_FULL_TRIGGER.trigger(serverPlayer);
            }
            int variantBeesCaught = briefcaseItem.m_41784_().m_128451_(TAG_VARANT_BEES);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer2 = (ServerPlayer)player;
                if (variantBeesCaught > 0) {
                    BzCriterias.VARIANT_BEE_BRIEFCASE_CAPTURE_TRIGGER.trigger(serverPlayer2, variantBeesCaught);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static List<Entity> dumpBees(Player player, int beeIndex, boolean releaseAtPlayer) {
        Level level = player.m_9236_();
        ItemStack briefcaseItem = player.m_21120_(InteractionHand.MAIN_HAND);
        int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
        if (numberOfBees > 0) {
            List<Object> bees = new ArrayList<Entity>();
            if (beeIndex == -1) {
                bees = BuzzingBriefcase.getBeesStored(level, briefcaseItem, true);
            } else {
                bees.add(BuzzingBriefcase.getSpecificBeesStored(level, briefcaseItem, beeIndex, true));
            }
            if (!bees.isEmpty()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)briefcaseItem.m_41720_()));
                float maxDistance = 15.0f;
                Vec3 playerEyePos = new Vec3(player.m_20185_(), player.m_20188_() - 0.25, player.m_20189_());
                Vec3 maxDistanceDirection = player.m_20154_().m_82542_((double)maxDistance, (double)maxDistance, (double)maxDistance);
                Vec3 finalPos = playerEyePos.m_82549_(maxDistanceDirection.m_82541_());
                if (!releaseAtPlayer) {
                    finalPos = playerEyePos.m_82549_(maxDistanceDirection);
                    EntityHitResult entityHitResult = ProjectileUtil.m_150175_((Level)level, (Entity)player, (Vec3)playerEyePos, (Vec3)finalPos, (AABB)player.m_20191_().m_82369_(maxDistanceDirection), entity -> !entity.m_20177_(player) && !BeeAggression.isBeelikeEntity(entity), (float)0.25f);
                    if (entityHitResult != null && entityHitResult.m_6662_() != HitResult.Type.MISS) {
                        finalPos = entityHitResult.m_82450_();
                    } else {
                        BlockHitResult hitResult = level.m_45547_(new ClipContext(playerEyePos, finalPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                        if (hitResult instanceof BlockHitResult) {
                            BlockHitResult blockHitResult = hitResult;
                            Vec3 locationClicked = hitResult.m_82450_();
                            Vec3 offset = Vec3.m_82528_((Vec3i)blockHitResult.m_82434_().m_122436_());
                            if (blockHitResult.m_82434_() == Direction.UP) {
                                offset = offset.m_82490_(0.35);
                            } else if (blockHitResult.m_82434_() != Direction.DOWN) {
                                offset = offset.m_82490_(0.5);
                            }
                            finalPos = locationClicked.m_82549_(offset);
                        }
                    }
                }
                Vec3 finalPos1 = finalPos;
                bees.forEach(bee -> {
                    bee.m_7678_(finalPos1.m_7096_(), finalPos1.m_7098_(), finalPos1.m_7094_(), player.m_146908_(), player.m_146909_());
                    level.m_7967_(bee);
                });
                level.m_5594_(null, player.m_20183_(), BzSounds.BUZZING_BRIEFCASE_RELEASES.get(), SoundSource.PLAYERS, 1.0f, player.m_217043_().m_188501_() * 0.2f + 0.6f);
                return new ArrayList<Object>(bees);
            }
        }
        return new ArrayList<Entity>();
    }

    public static List<Entity> getBeesStored(Level level, ItemStack briefcaseItem, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            CompoundTag briefcaseTag = briefcaseItem.m_41784_();
            ListTag beeList = briefcaseTag.m_128437_(TAG_BEES, 10);
            ObjectArrayList beesStored = new ObjectArrayList();
            if (removeFromList) {
                for (int i = beeList.size() - 1; i >= 0; --i) {
                    CompoundTag beeTag = beeList.m_128728_(0);
                    beeList.remove(0);
                    Entity entity = EntityType.m_20645_((CompoundTag)beeTag, (Level)level, entityx -> entityx);
                    if (entity == null) continue;
                    if (entity instanceof VariantBeeEntity) {
                        briefcaseTag.m_128405_(TAG_VARANT_BEES, Math.max(0, briefcaseTag.m_128451_(TAG_VARANT_BEES) - 1));
                    }
                    if (!BuzzingBriefcase.addBeeToList((List<Entity>)beesStored, beeTag, entity)) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < beeList.size(); ++i) {
                    CompoundTag beeTag = beeList.m_128728_(i);
                    Entity entity = EntityType.m_20645_((CompoundTag)beeTag, (Level)level, entityx -> entityx);
                    if (entity != null) {
                        if (!BuzzingBriefcase.addBeeToList((List<Entity>)beesStored, beeTag, entity)) continue;
                        break;
                    }
                    beeList.remove(i);
                    --i;
                }
            }
            return beesStored;
        }
        return new ObjectArrayList();
    }

    private static boolean addBeeToList(List<Entity> beesStored, CompoundTag beeTag, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (beeTag.m_128425_("Attributes", 9)) {
                livingEntity.m_21204_().m_22168_(beeTag.m_128437_("Attributes", 10));
            }
            if (beeTag.m_128425_("Health", 99)) {
                livingEntity.m_21153_(beeTag.m_128457_("Health"));
            }
        }
        beesStored.add(entity);
        return beesStored.size() == 14;
    }

    public static Entity getSpecificBeesStored(Level level, ItemStack briefcaseItem, int beeIndex, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            CompoundTag briefcaseTag = briefcaseItem.m_41784_();
            ListTag beeList = briefcaseTag.m_128437_(TAG_BEES, 10);
            if (beeIndex < beeList.size()) {
                Entity entity;
                CompoundTag beeTag = beeList.m_128728_(beeIndex);
                if (removeFromList) {
                    beeList.remove(beeIndex);
                }
                if ((entity = EntityType.m_20645_((CompoundTag)beeTag, (Level)level, entityx -> entityx)) instanceof VariantBeeEntity && removeFromList) {
                    briefcaseTag.m_128405_(TAG_VARANT_BEES, Math.max(0, briefcaseTag.m_128451_(TAG_VARANT_BEES) - 1));
                }
                return entity;
            }
            return null;
        }
        return null;
    }

    public static void overrwriteBees(ItemStack briefcaseItem, List<Entity> bees) {
        CompoundTag briefcaseTag = briefcaseItem.m_41784_();
        briefcaseTag.m_128473_(TAG_BEES);
        briefcaseTag.m_128473_(TAG_VARANT_BEES);
        bees.forEach(bee -> BuzzingBriefcase.tryAddBee(briefcaseItem, bee));
    }

    public static boolean tryAddBee(ItemStack briefcaseItem, Entity bee) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) < 14) {
            CompoundTag briefcaseTag = briefcaseItem.m_41784_();
            ListTag beeList = briefcaseTag.m_128437_(TAG_BEES, 10);
            CompoundTag beeTag = new CompoundTag();
            bee.m_20223_(beeTag);
            bee.m_8127_();
            bee.m_20153_();
            beeTag.m_128473_("UUID");
            beeList.add((Object)beeTag);
            bee.m_146870_();
            if (bee instanceof VariantBeeEntity) {
                briefcaseTag.m_128405_(TAG_VARANT_BEES, briefcaseTag.m_128451_(TAG_VARANT_BEES) + 1);
            }
            return true;
        }
        return false;
    }

    public static int getNumberOfBees(ItemStack briefcaseItem) {
        CompoundTag briefcaseTag = briefcaseItem.m_41784_();
        if (briefcaseTag.m_128441_(TAG_BEES)) {
            ListTag beeList = briefcaseTag.m_128437_(TAG_BEES, 10);
            return beeList.size();
        }
        ListTag listTag = new ListTag();
        briefcaseTag.m_128365_(TAG_BEES, (Tag)listTag);
        return 0;
    }
}

