/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.mojang.authlib.GameProfile;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.pollenpuffentityflowers.PollenPuffEntityPollinateManager;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.VineBlockAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.packets.UpdateFallingBlockPacket;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PollenPuffEntity
extends ThrowableItemProjectile {
    private boolean consumed = false;

    public PollenPuffEntity(EntityType<? extends PollenPuffEntity> entityType, Level world) {
        super(entityType, world);
    }

    public PollenPuffEntity(Level world, LivingEntity livingEntity) {
        super(BzEntities.POLLEN_PUFF_ENTITY.get(), livingEntity, world);
    }

    public PollenPuffEntity(Level world, double x, double y, double z) {
        super(BzEntities.POLLEN_PUFF_ENTITY.get(), x, y, z, world);
    }

    public void consumed() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    protected Item m_7881_() {
        return BzItems.POLLEN_PUFF.get();
    }

    public void m_8119_() {
        BlockHitResult raytraceresult;
        super.m_8119_();
        if (this.m_9236_().m_5776_() && (!this.m_20069_() || this.f_19796_.m_188501_() < 0.06f)) {
            for (int i = 0; i < 10; ++i) {
                PileOfPollen.spawnParticles((LevelAccessor)this.m_9236_(), this.m_20182_(), this.f_19796_, 0.015, 0.015, -0.001);
            }
        }
        if ((raytraceresult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82542_(1.0, 1.0, 1.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this))).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_204336_(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.m_204336_(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
                this.m_20221_(blockpos);
                this.m_6532_((HitResult)raytraceresult);
            } else if (blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) {
                this.m_6532_((HitResult)raytraceresult);
            }
        }
    }

    protected void m_6532_(HitResult rayTraceResult) {
        super.m_6532_(rayTraceResult);
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            for (int i = 0; i < 150; ++i) {
                PileOfPollen.spawnParticles((LevelAccessor)this.m_9236_(), this.m_20182_(), this.f_19796_, 0.04, 0.04, -0.001);
            }
        }
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        FallingBlockEntity fallingBlockEntity;
        LargeFireball fireball;
        ServerPlayer serverPlayer;
        if (this.m_9236_().m_5776_() || this.consumed) {
            return;
        }
        super.m_5790_(entityRayTraceResult);
        Entity entity = entityRayTraceResult.m_82443_();
        if (entity instanceof Bee && entity.m_6095_().m_204039_(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
            ((BeeEntityInvoker)entity).bumblezone$callSetHasNectar(true);
            ((Bee)entity).m_27853_();
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity2;
                BzCriterias.POLLEN_PUFF_POLLINATED_BEE_TRIGGER.trigger(serverPlayer);
            }
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            panda.m_29220_(true);
            Entity entity3 = this.m_19749_();
            if (entity3 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity3;
                BzCriterias.POLLEN_PUFF_PANDA_TRIGGER.trigger(serverPlayer);
            }
        } else if (entity instanceof LargeFireball) {
            fireball = (LargeFireball)entity;
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(vec3);
            fireball.f_36813_ = vec3.f_82479_ * 0.1;
            fireball.f_36814_ = vec3.f_82480_ * 0.1;
            fireball.f_36815_ = vec3.f_82481_ * 0.1;
            Entity pollenPuffOwner = this.m_19749_();
            if (pollenPuffOwner != null) {
                fireball.m_5602_(pollenPuffOwner);
            }
            if (pollenPuffOwner instanceof ServerPlayer) {
                ServerPlayer serverPlayer2 = (ServerPlayer)pollenPuffOwner;
                BzCriterias.POLLEN_PUFF_FIREBALL_TRIGGER.trigger(serverPlayer2);
            }
        } else if (entity instanceof FallingBlockEntity && (fallingBlockEntity = (FallingBlockEntity)entity).m_31980_().m_60713_(BzBlocks.PILE_OF_POLLEN.get())) {
            BlockState fallingState = fallingBlockEntity.m_31980_();
            int newLayer = Math.min(8, (Integer)fallingState.m_61143_((Property)PileOfPollen.LAYERS) + 1);
            ((FallingBlockEntityAccessor)fallingBlockEntity).bumblezone$bumblezone$setBlockState((BlockState)fallingState.m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(newLayer)));
            UpdateFallingBlockPacket.sendToClient((Entity)fallingBlockEntity, fallingBlockEntity.m_19879_(), (short)newLayer);
        }
        if (entity instanceof LivingEntity && (fireball = this.m_19749_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer3 = (ServerPlayer)fireball;
            PlayerDataHandler.onPollenHit((Player)serverPlayer3);
        }
        if (entity instanceof RootminEntity) {
            RootminEntity rootminEntity = (RootminEntity)entity;
            BlockState blockstate = rootminEntity.getFlowerBlock();
            if (blockstate != null && blockstate.m_204336_(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.m_204336_(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
                this.spawnPlants(rootminEntity.m_20183_(), (r, b) -> blockstate);
            }
        } else {
            WeightedStateProvider possiblePlants = PollenPuffEntityPollinateManager.POLLEN_PUFF_ENTITY_POLLINATE_MANAGER.getPossiblePlants(entity);
            if (possiblePlants != null && GeneralUtils.isPermissionAllowedAtSpot(this.m_9236_(), this.m_19749_(), BlockPos.m_274446_((Position)entityRayTraceResult.m_82450_()), true)) {
                boolean spawnedBlock = this.spawnPlants(entity.m_20183_(), (arg_0, arg_1) -> ((WeightedStateProvider)possiblePlants).m_213972_(arg_0, arg_1));
                Entity entity4 = this.m_19749_();
                if (entity4 instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity4;
                    if (spawnedBlock && entity.m_6095_() == EntityType.f_20504_) {
                        BzCriterias.POLLEN_PUFF_MOOSHROOM_TRIGGER.trigger(serverPlayer);
                    }
                }
            }
        }
        ItemStack beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
        if (!entity.m_6144_() && !beeLeggings.m_41619_()) {
            HoneyBeeLeggings.setPollinated(beeLeggings);
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.m_9236_().m_5776_() || this.consumed || !GeneralUtils.isPermissionAllowedAtSpot(this.m_9236_(), this.m_19749_(), blockHitResult.m_82425_(), true)) {
            return;
        }
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        if (blockstate.m_204336_(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.m_204336_(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
            this.spawnPlants(blockHitResult.m_82425_(), (r, b) -> blockstate);
        } else if (blockstate.m_60713_(Blocks.f_50719_) || blockstate.m_60713_(Blocks.f_50135_) || blockstate.m_60783_((BlockGetter)this.m_9236_(), blockHitResult.m_82425_(), blockHitResult.m_82434_())) {
            boolean belowSideStateHasCollision;
            BlockState pileOfPollen = BzBlocks.PILE_OF_POLLEN.get().m_49966_();
            BlockPos impactSide = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
            BlockState sideState = this.m_9236_().m_8055_(impactSide);
            BlockState belowSideState = this.m_9236_().m_8055_(impactSide.m_7495_());
            boolean bl = belowSideStateHasCollision = !belowSideState.m_60812_((BlockGetter)this.m_9236_(), impactSide.m_7495_()).m_83281_();
            if (sideState.m_60713_(pileOfPollen.m_60734_())) {
                PileOfPollen.stackPollen(sideState, this.m_9236_(), impactSide, pileOfPollen);
                this.consumed = true;
            } else if (!belowSideStateHasCollision && (sideState.m_60795_() || sideState.m_204336_(BlockTags.f_13076_)) || belowSideStateHasCollision && pileOfPollen.m_60710_((LevelReader)this.m_9236_(), impactSide) && sideState.m_247087_()) {
                this.m_9236_().m_7731_(impactSide, pileOfPollen, 3);
                this.consumed = true;
            }
        }
    }

    private boolean spawnPlants(BlockPos pos, BiFunction<RandomSource, BlockPos, BlockState> blockStateGetter) {
        boolean spawnedPlant = false;
        int flowerAttempts = 2 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < flowerAttempts; ++i) {
            BlockState belowState;
            boolean isWaterBased;
            BlockState targetBlock;
            boolean isTallPlant = false;
            BlockPos newPos = pos.m_7918_(this.f_19796_.m_188503_(5) - 2, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(5) - 2);
            BlockState blockstate = blockStateGetter.apply(this.f_19796_, newPos);
            if (blockstate == null || blockstate.m_60713_(Blocks.f_50016_)) {
                return false;
            }
            GameProfile gameProfile = null;
            Entity entity = this.m_19749_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                gameProfile = serverPlayer.m_36316_();
            }
            ServerPlayer fakePlayer = PlatformHooks.getFakePlayer((ServerLevel)this.m_9236_(), gameProfile);
            if (blockstate.m_60734_() instanceof DoublePlantBlock) {
                blockstate = (BlockState)blockstate.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                isTallPlant = true;
            } else {
                Block block = blockstate.m_60734_();
                if (block instanceof VineBlock) {
                    VineBlock vineBlock = (VineBlock)block;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        BooleanProperty faceProperty = VineBlock.m_57883_((Direction)direction);
                        boolean flag = ((VineBlockAccessor)vineBlock).bumblezone$callCanSupportAtFace((BlockGetter)this.m_9236_(), newPos, direction);
                        blockstate = (BlockState)blockstate.m_61124_((Property)faceProperty, (Comparable)Boolean.valueOf(flag));
                    }
                } else {
                    try {
                        BlockPlaceContext blockPlaceContext = new BlockPlaceContext((Player)fakePlayer, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.m_82512_((Vec3i)newPos.m_7494_()), Direction.UP, newPos, false));
                        blockstate = blockstate.m_60734_().m_5573_(blockPlaceContext);
                    }
                    catch (Exception e) {
                        Bumblezone.LOGGER.error("Pollen Puff: Unable to call getStateForPlacement for the following block: {} - Will use original default blockstate instead.", (Object)blockstate);
                    }
                    if (blockstate == null || blockstate.m_60713_(Blocks.f_50016_)) {
                        return false;
                    }
                }
            }
            boolean isFlowerAmount = false;
            if (blockstate.m_61138_((Property)BlockStateProperties.f_271526_) && (targetBlock = this.m_9236_().m_8055_(newPos)).m_60713_(blockstate.m_60734_()) && (Integer)targetBlock.m_61143_((Property)BlockStateProperties.f_271526_) < 4) {
                blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_271526_, (Comparable)Integer.valueOf((Integer)targetBlock.m_61143_((Property)BlockStateProperties.f_271526_) + 1));
                isFlowerAmount = true;
            }
            if (!((isWaterBased = blockstate.m_60819_().m_205070_(FluidTags.f_13131_)) ? this.m_9236_().m_8055_(newPos).m_60713_(Blocks.f_49990_) : (isFlowerAmount || this.m_9236_().m_46859_(newPos)) && blockstate.m_60710_((LevelReader)this.m_9236_(), newPos)) || blockstate.m_60713_(Blocks.f_152543_) && (BuiltInRegistries.f_256975_.m_7981_((Object)(belowState = this.m_9236_().m_8055_(newPos.m_7495_())).m_60734_()).m_135815_().contains("carpet") || belowState.m_204336_(BlockTags.f_13056_) || !belowState.m_60659_((BlockGetter)this.m_9236_(), newPos.m_7495_(), Direction.DOWN, SupportType.FULL)) || blockstate.m_60713_(Blocks.f_50570_) && ((belowState = this.m_9236_().m_8055_(newPos.m_7495_())).m_60713_(Blocks.f_50570_) || belowState.m_60713_(Blocks.f_50571_))) continue;
            this.m_9236_().m_7731_(newPos, blockstate, 3);
            blockstate.m_60734_().m_6402_(this.m_9236_(), newPos, blockstate, (LivingEntity)fakePlayer, ItemStack.f_41583_);
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                if (blockstate.m_204336_(BlockTags.f_13041_)) {
                    PlayerDataHandler.onFlowerSpawned((Player)serverPlayer);
                    if (isTallPlant) {
                        BzCriterias.POLLEN_PUFF_POLLINATED_TALL_FLOWER_TRIGGER.trigger(serverPlayer);
                    }
                }
            }
            spawnedPlant = true;
        }
        return spawnedPlant;
    }
}

