/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.RadianceEssence;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RadianceEssenceArmorMessage {
    private static final String DURABILITY_TEXT = "item.the_bumblezone.essence_radiance_durability_text";
    private static final String DURABILITY_LOW_TEXT = "item.the_bumblezone.essence_radiance_durability_low_text";
    private static final String ADVANCED_TEXT = "item.the_bumblezone.essence_radiance_advanced_text";
    private static final String HELMET_TEXT = "item.the_bumblezone.essence_radiance_helmet_text";
    private static final String CHESTPLATE_TEXT = "item.the_bumblezone.essence_radiance_chestplate_text";
    private static final String LEGGINGS_TEXT = "item.the_bumblezone.essence_radiance_leggings_text";
    private static final String BOOTS_TEXT = "item.the_bumblezone.essence_radiance_boots_text";

    public static void armorDurabilityMessage(Player player, GuiGraphics guiGraphics) {
        if (RadianceEssence.IsRadianceEssenceActive(player) && BzClientConfigs.radianceEssenceArmorDurability) {
            Minecraft minecraft = Minecraft.m_91087_();
            int i = 0;
            for (ItemStack armorStack : player.m_6168_()) {
                boolean isLowDurability = false;
                if (!armorStack.m_41619_()) {
                    MutableComponent bodyText;
                    int maxDamage = armorStack.m_41776_();
                    int currentHealth = armorStack.m_41776_() - armorStack.m_41773_();
                    if ((double)currentHealth < (double)maxDamage * 0.25) {
                        bodyText = Component.m_237110_((String)DURABILITY_LOW_TEXT, (Object[])new Object[]{currentHealth, maxDamage}).m_130940_(ChatFormatting.RED);
                        isLowDurability = true;
                    } else {
                        bodyText = Component.m_237110_((String)DURABILITY_TEXT, (Object[])new Object[]{currentHealth, maxDamage});
                    }
                    if (i == 3) {
                        line = RadianceEssenceArmorMessage.setupComponent(minecraft, HELMET_TEXT, bodyText, isLowDurability);
                        RadianceEssenceArmorMessage.renderScrollingString(minecraft, guiGraphics, armorStack, (Component)line, 60, 30);
                    } else if (i == 2) {
                        line = RadianceEssenceArmorMessage.setupComponent(minecraft, CHESTPLATE_TEXT, bodyText, isLowDurability);
                        RadianceEssenceArmorMessage.renderScrollingString(minecraft, guiGraphics, armorStack, (Component)line, 40, 20);
                    } else if (i == 1) {
                        line = RadianceEssenceArmorMessage.setupComponent(minecraft, LEGGINGS_TEXT, bodyText, isLowDurability);
                        RadianceEssenceArmorMessage.renderScrollingString(minecraft, guiGraphics, armorStack, (Component)line, 20, 10);
                    } else if (i == 0) {
                        line = RadianceEssenceArmorMessage.setupComponent(minecraft, BOOTS_TEXT, bodyText, isLowDurability);
                        RadianceEssenceArmorMessage.renderScrollingString(minecraft, guiGraphics, armorStack, (Component)line, 0, 0);
                    }
                }
                ++i;
            }
        }
    }

    private static MutableComponent setupComponent(Minecraft minecraft, String helmetText, MutableComponent bodyText, boolean isLowDurability) {
        MutableComponent line = Component.m_237110_((String)helmetText, (Object[])new Object[]{bodyText, GeneralUtilsClient.isAdvancedToolTipActive() ? Component.m_237115_((String)ADVANCED_TEXT) : Component.m_237119_()});
        if (isLowDurability) {
            line = line.m_130940_(ChatFormatting.RED);
        }
        return line;
    }

    public static void renderScrollingString(Minecraft minecraft, GuiGraphics guiGraphics, ItemStack armorItem, Component component, int yOffset, int yOffset2) {
        if (component == null) {
            return;
        }
        int startOfHotbar = (guiGraphics.m_280182_() - 250) / 2;
        GeneralUtilsClient.renderScrollingString(guiGraphics, minecraft.f_91062_, component, BzClientConfigs.radianceEssenceArmorDurabilityXCoord, guiGraphics.m_280206_() - BzClientConfigs.radianceEssenceArmorDurabilityYCoord - yOffset, BzClientConfigs.radianceEssenceArmorDurabilityXCoord + startOfHotbar, guiGraphics.m_280206_(), 16769168);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)(BzClientConfigs.radianceEssenceArmorDurabilityXCoord - 2), (float)(guiGraphics.m_280206_() - (BzClientConfigs.radianceEssenceArmorDurabilityYCoord - 2) - yOffset2), 0.0f);
        pose.m_85841_(0.7f, 0.7f, 1.0f);
        guiGraphics.m_280480_(armorItem, 0, 0);
        pose.m_85849_();
    }
}

