/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.platform;

import com.bawnorton.neruina.platform.ModLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public final class Platform {
    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String modid) {
        List mods = LoadingModList.get().getMods();
        for (ModInfo mod : mods) {
            if (!mod.getModId().equals(modid)) continue;
            return true;
        }
        return false;
    }

    public static ModLoader getModLoader() {
        return ModLoader.FORGE;
    }

    public static String modidFromJar(String jarName) {
        for (IModInfo mod : ModList.get().getMods()) {
            String modLocation = mod.getOwningFile().getFile().getFilePath().toString().replace("+", " ");
            String decodedJarName = URLDecoder.decode(jarName, StandardCharsets.UTF_8);
            int hashIndex = decodedJarName.lastIndexOf("#");
            if (hashIndex != -1) {
                decodedJarName = decodedJarName.substring(0, hashIndex);
            }
            if (!modLocation.endsWith(decodedJarName)) continue;
            return mod.getModId();
        }
        return null;
    }

    public static String getModVersion(String modid) {
        return ModList.get().getModFileById(modid).versionString();
    }

    public static String getVersion() {
        return FMLLoader.versionInfo().forgeVersion();
    }

    public static boolean isClient() {
        return FMLLoader.getDist().isClient();
    }
}

