/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.ender_pack.core.registry;

import forge.com.cursee.ender_pack.Constants;
import forge.com.cursee.ender_pack.core.registry.ModBlockEntities;
import forge.com.cursee.ender_pack.core.registry.ModBlocks;
import forge.com.cursee.ender_pack.core.registry.ModItems;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RegistryForge {
    private static final Set<Item> CREATIVE_MODE_TAB_ITEMS = new LinkedHashSet<Item>();

    public static void register(IEventBus modEventBus) {
        RegistryForge.bind(Registries.f_256747_, consumer -> ModBlocks.register(consumer));
        RegistryForge.bindForItems(ModItems::register);
        RegistryForge.bind(Registries.f_256922_, ModBlockEntities::register);
        RegistryForge.bind(Registries.f_279569_, consumer -> consumer.accept(CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModItems.ENDER_PACK)).m_257941_((Component)Component.m_237115_((String)"itemGroup.enderPack")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257652_(), Constants.ENDER_PACK_TAB_KEY.m_135782_()));
        modEventBus.addListener(entries -> {
            if (entries.getTabKey() == Constants.ENDER_PACK_TAB_KEY) {
                CREATIVE_MODE_TAB_ITEMS.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)entries).m_246326_(arg_0));
            }
        });
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void bindForItems(Consumer<BiConsumer<Item, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                source.accept((t, rl) -> {
                    CREATIVE_MODE_TAB_ITEMS.add((Item)t);
                    event.register(Registries.f_256913_, rl, () -> t);
                });
            }
        });
    }
}

