/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.common.worldgen.feature;

import com.mojang.serialization.Codec;
import com.obscuria.aquamirae.common.blocks.OxygeliumBlock;
import com.obscuria.aquamirae.registry.AquamiraeBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OxygeliumFeature
extends Feature<NoneFeatureConfiguration> {
    private final List<Block> BLOCKS = List.of(Blocks.f_49994_);

    public OxygeliumFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        boolean flag2;
        int l;
        int xo = context.m_159777_().m_123341_() + context.m_225041_().m_216339_(-6, 6);
        int zo = context.m_159777_().m_123343_() + context.m_225041_().m_216339_(-6, 6);
        BlockPos mainPos = new BlockPos(xo, context.m_159774_().m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xo, zo) - 1, zo);
        if (!this.BLOCKS.contains(context.m_159774_().m_8055_(mainPos).m_60734_())) {
            return false;
        }
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        boolean flag = randomsource.m_188500_() > 0.7;
        BlockState blockstate = Blocks.f_50069_.m_49966_();
        double d0 = randomsource.m_188500_() * 2.0 * Math.PI;
        int i = 11 - randomsource.m_188503_(5);
        int j = 3 + randomsource.m_188503_(3);
        boolean flag1 = randomsource.m_188500_() > 0.7;
        int n = l = flag1 ? randomsource.m_188503_(6) + 6 : randomsource.m_188503_(15) + 3;
        if (!flag1 && randomsource.m_188500_() > 0.9) {
            l += randomsource.m_188503_(19) + 7;
        }
        int i1 = Math.min(l + randomsource.m_188503_(11), 18);
        int j1 = Math.min(l + randomsource.m_188503_(7) - randomsource.m_188503_(5), 11);
        int k1 = flag1 ? i : 11;
        for (int l1 = -k1; l1 < k1; ++l1) {
            for (int i2 = -k1; i2 < k1; ++i2) {
                for (int j2 = 0; j2 < l; ++j2) {
                    int k2;
                    int n2 = k2 = flag1 ? this.heightDependentRadiusEllipse(j2, l, j1) : this.heightDependentRadiusRound(randomsource, j2, l, j1);
                    if (!flag1 && l1 >= k2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, mainPos, l, l1, j2, i2, k2, k1, flag1, j, d0, flag, blockstate);
                }
            }
        }
        this.smooth((LevelAccessor)worldgenlevel, mainPos, j1, l, flag1, i);
        for (int i3 = -k1; i3 < k1; ++i3) {
            for (int j3 = -k1; j3 < k1; ++j3) {
                for (int k3 = -1; k3 > -i1; --k3) {
                    int l3 = flag1 ? Mth.m_14167_((float)((float)k1 * (1.0f - (float)Math.pow(k3, 2.0) / ((float)i1 * 8.0f)))) : k1;
                    int l2 = this.heightDependentRadiusSteep(randomsource, -k3, i1, j1);
                    if (i3 >= l2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, mainPos, i1, i3, k3, j3, l2, l3, flag1, j, d0, flag, blockstate);
                }
            }
        }
        boolean bl = flag1 ? randomsource.m_188500_() > 0.1 : (flag2 = randomsource.m_188500_() > 0.7);
        if (flag2) {
            this.generateCutOut(randomsource, (LevelAccessor)worldgenlevel, j1, l, mainPos, flag1, i, d0, j);
        }
        int count = context.m_225041_().m_216339_(3, 13);
        for (int index = 0; index <= count; ++index) {
            int x = (int)((double)context.m_159777_().m_123341_() + context.m_225041_().m_216328_(0.0, 4.0));
            int z = (int)((double)context.m_159777_().m_123343_() + context.m_225041_().m_216328_(0.0, 4.0));
            int y = context.m_159774_().m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
            this.placeOxygelium(context.m_159774_(), x, y, z, context.m_225041_());
        }
        this.placeElodea(worldgenlevel, mainPos.m_123341_(), mainPos.m_123342_(), mainPos.m_123343_(), randomsource);
        return true;
    }

    private void placeOxygelium(WorldGenLevel world, int x, int y, int z, RandomSource random) {
        int max = random.m_216339_(3, 10);
        for (int i = 0; i <= max; ++i) {
            BlockState below = world.m_8055_(new BlockPos(x, y + i - 1, z));
            BlockState state = world.m_8055_(new BlockPos(x, y + i, z));
            BlockState above = world.m_8055_(new BlockPos(x, y + i + 1, z));
            if (!below.m_280296_() && !this.isStem(below) || !state.m_278721_()) continue;
            if (above.m_280296_()) {
                world.m_7731_(new BlockPos(x, y + i, z), (BlockState)((BlockState)((Block)AquamiraeBlocks.OXYGELIUM.get()).m_49966_().m_61124_(OxygeliumBlock.TYPE, (Comparable)((Object)(i < max ? OxygeliumBlock.Type.STEM : OxygeliumBlock.Type.EMPTY_BUD)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE), 3);
                continue;
            }
            world.m_7731_(new BlockPos(x, y + i, z), (BlockState)((BlockState)((Block)AquamiraeBlocks.OXYGELIUM.get()).m_49966_().m_61124_(OxygeliumBlock.TYPE, (Comparable)((Object)OxygeliumBlock.Type.EMPTY_BUD))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE), 3);
        }
    }

    private boolean isStem(BlockState state) {
        return state.m_60713_((Block)AquamiraeBlocks.OXYGELIUM.get()) && state.m_61143_(OxygeliumBlock.TYPE) == OxygeliumBlock.Type.STEM;
    }

    private void placeElodea(WorldGenLevel world, int x, int y, int z, RandomSource random) {
        int max = random.m_216339_(4, 24);
        block0: for (int i = 0; i <= max; ++i) {
            BlockPos pos = new BlockPos(x + (int)Math.round(random.m_216328_(0.0, 7.0)), y - 4, z + (int)Math.round(random.m_216328_(0.0, 7.0)));
            for (int offset = 0; offset <= 10; ++offset) {
                if (world.m_8055_(pos.m_6630_(offset - 1)).m_60734_() != Blocks.f_49994_ && world.m_8055_(pos.m_6630_(offset - 1)).m_60734_() != Blocks.f_50069_ && world.m_8055_(pos.m_6630_(offset - 1)).m_60734_() != Blocks.f_50652_ || world.m_8055_(pos.m_6630_(offset)).m_60734_() != Blocks.f_49990_) continue;
                world.m_7731_(pos.m_6630_(offset), (BlockState)((Block)AquamiraeBlocks.ELODEA.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
                continue block0;
            }
        }
    }

    private void generateCutOut(RandomSource p_225100_, LevelAccessor p_225101_, int p_225102_, int p_225103_, BlockPos p_225104_, boolean p_225105_, int p_225106_, double p_225107_, int p_225108_) {
        int i = p_225100_.m_188499_() ? -1 : 1;
        int j = p_225100_.m_188499_() ? -1 : 1;
        int k = p_225100_.m_188503_(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.m_188499_()) {
            k = p_225102_ / 2 + 1 - p_225100_.m_188503_(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        int l = p_225100_.m_188503_(Math.max(p_225102_ / 2 - 2, 1));
        if (p_225100_.m_188499_()) {
            l = p_225102_ / 2 + 1 - p_225100_.m_188503_(Math.max(p_225102_ - p_225102_ / 2 - 1, 1));
        }
        if (p_225105_) {
            k = l = p_225100_.m_188503_(Math.max(p_225106_ - 5, 1));
        }
        BlockPos blockpos = new BlockPos(i * k, 0, j * l);
        double d0 = p_225105_ ? p_225107_ + 1.5707963267948966 : p_225100_.m_188500_() * 2.0 * Math.PI;
        for (int i1 = 0; i1 < p_225103_ - 3; ++i1) {
            int j1 = this.heightDependentRadiusRound(p_225100_, i1, p_225103_, p_225102_);
            this.carve(j1, i1, p_225104_, p_225101_, false, d0, blockpos, p_225106_, p_225108_);
        }
        for (int k1 = -1; k1 > -p_225103_ + p_225100_.m_188503_(5); --k1) {
            int l1 = this.heightDependentRadiusSteep(p_225100_, -k1, p_225103_, p_225102_);
            this.carve(l1, k1, p_225104_, p_225101_, true, d0, blockpos, p_225106_, p_225108_);
        }
    }

    private void carve(int p_66036_, int p_66037_, BlockPos p_66038_, LevelAccessor p_66039_, boolean p_66040_, double p_66041_, BlockPos p_66042_, int p_66043_, int p_66044_) {
        int i = p_66036_ + 1 + p_66043_ / 3;
        int j = Math.min(p_66036_ - 3, 3) + p_66044_ / 2 - 1;
        for (int k = -i; k < i; ++k) {
            for (int l = -i; l < i; ++l) {
                BlockPos blockpos;
                BlockState blockstate;
                double d0 = this.signedDistanceEllipse(k, l, p_66042_, i, j, p_66041_);
                if (!(d0 < 0.0) || !OxygeliumFeature.isIcebergState(blockstate = p_66039_.m_8055_(blockpos = p_66038_.m_7918_(k, p_66037_, l))) || !p_66040_) continue;
                this.m_5974_((LevelWriter)p_66039_, blockpos, Blocks.f_49990_.m_49966_());
            }
        }
    }

    private void generateIcebergBlock(LevelAccessor p_225110_, RandomSource p_225111_, BlockPos pos, int p_225113_, int p_225114_, int p_225115_, int p_225116_, int p_225117_, int p_225118_, boolean p_225119_, int p_225120_, double p_225121_, boolean p_225122_, BlockState p_225123_) {
        double d0;
        double d = d0 = p_225119_ ? this.signedDistanceEllipse(p_225114_, p_225116_, BlockPos.f_121853_, p_225118_, this.getEllipseC(p_225115_, p_225113_, p_225120_), p_225121_) : this.signedDistanceCircle(p_225114_, p_225116_, p_225117_, p_225111_);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos = pos.m_7918_(p_225114_, p_225115_, p_225116_);
            double d2 = d1 = p_225119_ ? -0.5 : (double)(-6 - p_225111_.m_188503_(3));
            if (d0 > d1 && p_225111_.m_188500_() > 0.9) {
                return;
            }
            this.setIcebergBlock(blockpos, p_225110_, p_225111_, p_225113_ - p_225115_, p_225113_, p_225119_, p_225122_, p_225123_);
        }
    }

    private void setIcebergBlock(BlockPos pos, LevelAccessor levelAccessor, RandomSource p_225127_, int p_225128_, int p_225129_, boolean p_225130_, boolean p_225131_, BlockState p_225132_) {
        if (levelAccessor.m_8055_(pos.m_7494_()).m_60795_()) {
            return;
        }
        BlockState blockstate = levelAccessor.m_8055_(pos);
        if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_50127_) || blockstate.m_60713_(Blocks.f_50126_) || blockstate.m_60713_(Blocks.f_49990_)) {
            int i;
            boolean flag = !p_225130_ || p_225127_.m_188500_() > 0.05;
            int n = i = p_225130_ ? 3 : 2;
            if (p_225131_ && (double)p_225128_ <= (double)p_225127_.m_188503_(Math.max(1, p_225129_ / i)) + (double)p_225129_ * 0.6 && flag) {
                this.m_5974_((LevelWriter)levelAccessor, pos, Blocks.f_50652_.m_49966_());
            } else {
                this.m_5974_((LevelWriter)levelAccessor, pos, p_225132_);
            }
        }
    }

    private int getEllipseC(int p_66019_, int p_66020_, int p_66021_) {
        int i = p_66021_;
        if (p_66019_ > 0 && p_66020_ - p_66019_ <= 3) {
            i = p_66021_ - (4 - (p_66020_ - p_66019_));
        }
        return i;
    }

    private double signedDistanceCircle(int p_225089_, int p_225090_, int p_225092_, RandomSource p_225093_) {
        float f = 10.0f * Mth.m_14036_((float)p_225093_.m_188501_(), (float)0.2f, (float)0.8f) / (float)p_225092_;
        return (double)f + Math.pow(p_225089_ - BlockPos.f_121853_.m_123341_(), 2.0) + Math.pow(p_225090_ - BlockPos.f_121853_.m_123343_(), 2.0) - Math.pow(p_225092_, 2.0);
    }

    private double signedDistanceEllipse(int p_66023_, int p_66024_, BlockPos p_66025_, int p_66026_, int p_66027_, double p_66028_) {
        return Math.pow(((double)(p_66023_ - p_66025_.m_123341_()) * Math.cos(p_66028_) - (double)(p_66024_ - p_66025_.m_123343_()) * Math.sin(p_66028_)) / (double)p_66026_, 2.0) + Math.pow(((double)(p_66023_ - p_66025_.m_123341_()) * Math.sin(p_66028_) + (double)(p_66024_ - p_66025_.m_123343_()) * Math.cos(p_66028_)) / (double)p_66027_, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(RandomSource p_225095_, int p_225096_, int p_225097_, int p_225098_) {
        float f = 3.5f - p_225095_.m_188501_();
        float f1 = (1.0f - (float)Math.pow(p_225096_, 2.0) / ((float)p_225097_ * f)) * (float)p_225098_;
        if (p_225097_ > 15 + p_225095_.m_188503_(5)) {
            int i = p_225096_ < 3 + p_225095_.m_188503_(6) ? p_225096_ / 2 : p_225096_;
            f1 = (1.0f - (float)i / ((float)p_225097_ * f * 0.4f)) * (float)p_225098_;
        }
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusEllipse(int p_66110_, int p_66111_, int p_66112_) {
        float f1 = (1.0f - (float)Math.pow(p_66110_, 2.0) / (float)p_66111_) * (float)p_66112_;
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusSteep(RandomSource p_225134_, int p_225135_, int p_225136_, int p_225137_) {
        float f = 1.0f + p_225134_.m_188501_() / 2.0f;
        float f1 = (1.0f - (float)p_225135_ / ((float)p_225136_ * f)) * (float)p_225137_;
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private static boolean isIcebergState(BlockState p_159886_) {
        return p_159886_.m_60713_(Blocks.f_50069_) || p_159886_.m_60713_(Blocks.f_50652_);
    }

    private boolean belowIsAir(BlockGetter p_66046_, BlockPos p_66047_) {
        return p_66046_.m_8055_(p_66047_.m_7495_()).m_60734_() == Blocks.f_49990_;
    }

    private void smooth(LevelAccessor p_66052_, BlockPos p_66053_, int p_66054_, int p_66055_, boolean p_66056_, int p_66057_) {
        int i = p_66056_ ? p_66057_ : p_66054_ / 2;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                for (int l = 0; l <= p_66055_; ++l) {
                    BlockPos blockpos = p_66053_.m_7918_(j, l, k);
                    BlockState blockstate = p_66052_.m_8055_(blockpos);
                    if (!OxygeliumFeature.isIcebergState(blockstate)) continue;
                    if (this.belowIsAir((BlockGetter)p_66052_, blockpos)) {
                        this.m_5974_((LevelWriter)p_66052_, blockpos, Blocks.f_49990_.m_49966_());
                        this.m_5974_((LevelWriter)p_66052_, blockpos.m_7494_(), Blocks.f_49990_.m_49966_());
                        continue;
                    }
                    if (!OxygeliumFeature.isIcebergState(blockstate)) continue;
                    BlockState[] ablockstate = new BlockState[]{p_66052_.m_8055_(blockpos.m_122024_()), p_66052_.m_8055_(blockpos.m_122029_()), p_66052_.m_8055_(blockpos.m_122012_()), p_66052_.m_8055_(blockpos.m_122019_())};
                    int i1 = 0;
                    for (BlockState blockstate1 : ablockstate) {
                        if (OxygeliumFeature.isIcebergState(blockstate1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    this.m_5974_((LevelWriter)p_66052_, blockpos, Blocks.f_49990_.m_49966_());
                }
            }
        }
    }
}

