/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.ChopEvent;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NoChopOnRightClick {
    private static final Map<Entity, Long> lastRightClickTickByPlayers = new HashMap<Entity, Long>();
    private static boolean enabled = false;

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (((Boolean)ConfigHandler.COMMON.preventChoppingOnRightClick.get()).booleanValue()) {
            NoChopOnRightClick.enable();
        }
    }

    public static void enable() {
        if (!enabled) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
            enabled = true;
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockStartClick(PlayerInteractEvent.RightClickBlock event) {
            long time = event.getLevel().m_46467_();
            lastRightClickTickByPlayers.put((Entity)event.getEntity(), time);
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            long time = event.getLevel().m_46467_();
            if (lastRightClickTickByPlayers.getOrDefault(event.getPlayer(), TickUtil.NEVER) == time) {
                event.setCanceled(true);
            }
        }
    }
}

