/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage.core.message;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import fabric.com.cursee.automessage.AutoMessage;
import fabric.com.cursee.automessage.Constants;
import fabric.com.cursee.automessage.core.data.ClientMessages;
import fabric.com.cursee.automessage.core.data.ServerMessages;
import fabric.com.cursee.automessage.core.message.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;

public class MessageServiceUtil {
    public static void copyResourceToFile(String resource, File destination) {
        try (InputStream input = AutoMessage.class.getResourceAsStream(resource);){
            if (input == null) {
                throw new class_151("Invalid resource path: " + resource);
            }
            destination.getParentFile().mkdirs();
            try (FileOutputStream output = new FileOutputStream(destination);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                Constants.LOG.info("Copied resource to: {}", (Object)destination.getAbsolutePath());
            }
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to write {} to file: {}", (Object)resource, (Object)destination.getPath());
            Constants.LOG.info(e.toString());
            e.fillInStackTrace();
        }
    }

    public static void loadFallbackMessages(Gson gson) {
        block13: {
            try (InputStream in = AutoMessage.class.getResourceAsStream("/assets/automessage/default_messages.json");){
                if (in == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(in);){
                    Type listType = new TypeToken<List<Message>>(){}.getType();
                    List fallback = (List)gson.fromJson((Reader)reader, listType);
                    ClientMessages.ON_FIRST_JOIN_MESSAGES.addAll(fallback);
                    ServerMessages.ON_FIRST_JOIN_MESSAGES.addAll(fallback);
                    Constants.LOG.info("Loaded fallback messages from mod resources.");
                }
                return;
            }
            catch (Exception e) {
                Constants.LOG.info("Failed to load fallback message resource.");
                Constants.LOG.info(e.toString());
                e.fillInStackTrace();
            }
        }
        Message fallbackMessage = Message.defaultFallback();
        ClientMessages.ON_FIRST_JOIN_MESSAGES.add(fallbackMessage);
        ServerMessages.ON_FIRST_JOIN_MESSAGES.add(fallbackMessage);
        Constants.LOG.info("Loaded hard-coded fallback message.");
    }

    public static ArrayList<File> resolveMessagePaths(String pattern) {
        ArrayList<File> results = new ArrayList<File>();
        Path configDir = new File("config").toPath();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        try (Stream<Path> pathStream = Files.walk(configDir, new FileVisitOption[0]);){
            pathStream.filter(path -> matcher.matches(configDir.relativize((Path)path))).forEach(path -> results.add(path.toFile()));
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to resolve glob : {}", (Object)pattern);
            Constants.LOG.info(e.toString());
            e.fillInStackTrace();
        }
        return results;
    }

    public static boolean areAllListsEmpty(List<List<?>> lists) {
        if (lists == null) {
            return true;
        }
        for (List<?> list : lists) {
            if (list == null || list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static class_2561 styledComponent(Message message, class_1657 player) {
        String s = MessageServiceUtil.replaceVarsInText(message.text, player, message.link);
        if (message.link == null || message.link.isBlank()) {
            return class_2561.method_43470((String)s);
        }
        return class_2561.method_43470((String)s).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, message.link)));
    }

    private static String replaceVarsInText(String text, class_1657 player, String link) {
        return text.replace("%player%", player.method_5476().getString()).replace("%link%", link != null ? link : "").replaceAll("\u00c2", "").replace("\u00c2", "");
    }
}

