/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.automessage;

import common.com.cursee.automessage.AutoMessage;
import common.com.cursee.automessage.Constants;
import common.com.cursee.automessage.core.ClientMessageService;
import common.com.cursee.automessage.core.data.ClientMessages;
import common.com.cursee.automessage.core.message.Message;
import common.com.cursee.automessage.core.message.MessageServiceUtil;
import common.com.cursee.automessage.core.message.MessageType;
import common.com.cursee.automessage.core.util.JsonFileHelper;
import common.com.cursee.automessage.platform.Services;
import java.io.File;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class AutoMessageClient {
    public static Minecraft CLIENT = null;
    private static final String AUTOMESSAGE_DATA_DIR_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data";
    private static final String CLIENT_SERVER_TAGS_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data" + File.separator + "client_server_tags.json";

    public static void init(Minecraft client) {
        CLIENT = client;
        new ClientMessageService().load();
        if (AutoMessage.checkFileExisted) {
            return;
        }
        File autoMessageDataDirectory = new File(AUTOMESSAGE_DATA_DIR_FILEPATH);
        if (!autoMessageDataDirectory.isDirectory()) {
            autoMessageDataDirectory.mkdirs();
        }
        if (JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin") && JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin")) {
            return;
        }
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin");
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin");
    }

    public static String worldNameOrServerIP() {
        Object s;
        if (CLIENT == null) {
            throw new IllegalStateException("Attempted to get world name or server IP address from NULL client");
        }
        if (CLIENT.m_91091_()) {
            MinecraftServer server = (MinecraftServer)Objects.requireNonNull(CLIENT.m_91092_());
            s = server.m_129843_(LevelResource.f_78176_).toString();
            s = ((String)s).replaceAll("(?s)^.*?(?=" + server.m_129910_().m_5462_() + ")", "").replace(File.separatorChar + "playerdata", "");
        } else {
            s = Objects.requireNonNull(AutoMessageClient.CLIENT.m_91089_()).f_105363_ + Objects.requireNonNull(AutoMessageClient.CLIENT.m_91089_()).f_105362_;
        }
        System.out.println("Attempted to return worldNameOrServerIP with value: " + (String)s);
        return s;
    }

    public static void onFirstJoin(LocalPlayer player, ClientLevel level) {
        ClientMessages.ON_FIRST_JOIN_MESSAGES.forEach(message -> {
            boolean anyKeyContainsTag = JsonFileHelper.anyKeyContainsTag(new File(CLIENT_SERVER_TAGS_FILEPATH), message.identifier + ".firstJoin");
            if (message.pack_intro && anyKeyContainsTag) {
                Constants.LOG.info("Message with identifier {} is marked as a modpack introduction and has already been displayed to {}, skipping.", (Object)message.identifier, (Object)player.m_6302_());
                return;
            }
            AutoMessageClient.trySendMessageOnce((Player)player, message, "firstJoin");
        });
    }

    public static void onJoinLevel(LocalPlayer player, ClientLevel level) {
        ClientMessages.ON_JOIN_LEVEL_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((Player)player, message, "join"));
    }

    public static void onDeath(LocalPlayer player, ClientLevel level) {
        ClientMessages.ON_DEATH_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((Player)player, message, "death"));
    }

    public static void onRespawn(LocalPlayer player, ClientLevel level) {
        ClientMessages.ON_RESPAWN_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((Player)player, message, "respawn"));
    }

    public static void trySendMessageOnce(Player player, Message message, String suffix) {
        if (!ClientMessageService.instance.general.enabled) {
            return;
        }
        String serverName = AutoMessageClient.worldNameOrServerIP();
        boolean hasTag = JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + "." + suffix);
        if (message.repeats || !hasTag) {
            player.m_5661_(MessageServiceUtil.styledComponent(message, player), message.type == MessageType.OVERLAY);
            if (!message.repeats && !hasTag) {
                JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + "." + suffix);
            }
        }
    }
}

