/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.entity.AzEntityNameRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final AzEntityRendererConfig<T> config;
    protected final AzProvider<T> provider;
    protected final AzEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzEntityAnimator<T> reusedAzEntityAnimator;

    protected AzEntityRenderer(AzEntityRendererConfig<T> config, EntityRendererProvider.Context context) {
        super(context);
        this.config = config;
        this.provider = new AzProvider<Entity>(config::createAnimator, config::modelLocation);
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzEntityRendererPipeline<T> createPipeline(AzEntityRendererConfig<T> config) {
        return new AzEntityRendererPipeline<T>(config, this);
    }

    @NotNull
    public final ResourceLocation m_5478_(@NotNull T animatable) {
        return this.config.textureLocation(animatable);
    }

    public void superRender(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void m_7392_(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        AzEntityAnimator cachedEntityAnimator = (AzEntityAnimator)this.provider.provideAnimator(entity);
        AzBakedModel azBakedModel = this.provider.provideBakedModel(entity);
        if (cachedEntityAnimator != null && azBakedModel != null) {
            cachedEntityAnimator.setActiveModel(azBakedModel);
        }
        this.f_114477_ = this.config.shadowRadius(entity);
        this.reusedAzEntityAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, azBakedModel, entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    public boolean m_6512_(@NotNull T entity) {
        return AzEntityNameRenderUtil.shouldShowName(this.f_114476_, entity);
    }

    public int m_6086_(@NotNull T entity, @NotNull BlockPos pos) {
        return super.m_6086_(entity, pos);
    }

    public AzEntityAnimator<T> getAnimator() {
        return this.reusedAzEntityAnimator;
    }

    public AzEntityRendererConfig<T> config() {
        return this.config;
    }
}

