/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererPipelineContext
extends AzRendererPipelineContext<ItemStack> {
    private final AzArmorBoneContext boneContext = new AzArmorBoneContext();
    private HumanoidModel<?> baseModel = null;
    private Entity currentEntity = null;
    private EquipmentSlot currentSlot = null;
    private ItemStack currentStack = null;
    private boolean translucent = false;

    public AzArmorRendererPipelineContext(AzRendererPipeline<ItemStack> rendererPipeline) {
        super(rendererPipeline);
    }

    @Override
    @NotNull
    public RenderType getDefaultRenderType(ItemStack animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick, RenderType defaultRenderType, float alpha) {
        return this.translucent ? RenderType.m_110467_((ResourceLocation)texture) : defaultRenderType;
    }

    public void prepare(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlot slot, @Nullable HumanoidModel<?> baseModel) {
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = stack;
        this.currentSlot = slot;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    @Override
    public Color getRenderColor(ItemStack animatable, float partialTick, int packedLight) {
        Color color;
        Item item = this.currentStack.m_41720_();
        if (item instanceof DyeableArmorItem) {
            DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)item;
            color = Color.ofOpaque(dyeableArmorItem.m_41121_(animatable));
        } else {
            color = Color.WHITE;
        }
        return color;
    }

    public HumanoidModel<?> baseModel() {
        return this.baseModel;
    }

    public AzArmorBoneContext boneContext() {
        return this.boneContext;
    }

    public Entity currentEntity() {
        return this.currentEntity;
    }

    public EquipmentSlot currentSlot() {
        return this.currentSlot;
    }

    public ItemStack currentStack() {
        return this.currentStack;
    }
}

