/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface Growable {
    public float getGrowth();

    public void setGrowth(float var1);

    public float getMaxGrowth();

    default public void grow(LivingEntity entity, float amount) {
        this.setGrowth(Math.min(this.getGrowth() + amount, this.getMaxGrowth()));
        if (this.getGrowth() >= this.getMaxGrowth()) {
            this.growUp(entity);
        }
    }

    public LivingEntity growInto();

    default public void growUp(LivingEntity entity) {
        Level world = entity.m_9236_();
        if (!world.m_5776_()) {
            LivingEntity newEntity = this.growInto();
            if (newEntity == null) {
                return;
            }
            newEntity.m_20035_(entity.m_20183_(), entity.m_146908_(), entity.m_146909_());
            world.m_7967_((Entity)newEntity);
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    default public float getGrowthNeededUntilGrowUp() {
        return this.getMaxGrowth() - this.getGrowth();
    }

    default public float getGrowthMultiplier() {
        return 1.0f;
    }
}

