/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.commands.arguments.SkillArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class SkillsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skills").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::unlock)))))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::lock)))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(SkillsCommand::reset))));
    }

    private static int unlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (ServerPlayer player : players) {
            skill.unlock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.unlock", category.getId(), skill.getId());
        return players.size();
    }

    private static int lock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (ServerPlayer player : players) {
            skill.lock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.lock", category.getId(), skill.getId());
        return players.size();
    }

    private static int reset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.resetSkills(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.reset", category.getId());
        return players.size();
    }
}

