/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;

public enum Operator {
    LESS("<"),
    LESS_EQUAL("<="),
    EQUAL("=="),
    GREATER_EQUAL(">="),
    GREATER(">");

    private final String symbol;
    public static final Codec<Operator> CODEC;

    private Operator(String symbol) {
        this.symbol = symbol;
    }

    public boolean apply(int first, int second) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LESS -> {
                if (first < second) {
                    yield true;
                }
                yield false;
            }
            case LESS_EQUAL -> {
                if (first <= second) {
                    yield true;
                }
                yield false;
            }
            case EQUAL -> {
                if (first == second) {
                    yield true;
                }
                yield false;
            }
            case GREATER_EQUAL -> {
                if (first >= second) {
                    yield true;
                }
                yield false;
            }
            case GREATER -> first > second;
        };
    }

    static {
        CODEC = Codec.STRING.flatXmap(string -> {
            for (Operator o : Operator.values()) {
                if (!o.name().toLowerCase(Locale.ROOT).equals(string) && !o.symbol.equals(string)) continue;
                return DataResult.success((Object)((Object)o));
            }
            return DataResult.error(() -> "Unknown Operator " + string);
        }, o -> DataResult.success((Object)o.symbol));
    }
}

