/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.golden_foods.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EnchantedGoldenCakeBlock
extends CakeBlock {
    public EnchantedGoldenCakeBlock() {
        super(BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.CAKE));
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionhand, @NotNull BlockHitResult blockHitResult) {
        Block block;
        ItemStack itemStack = player.getItemInHand(interactionhand);
        Item item = itemStack.getItem();
        if (itemStack.is(ItemTags.CANDLES) && (Integer)blockState.getValue((Property)BITES) == 0 && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            level.playSound((Player)null, blockPos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(blockPos, CandleCakeBlock.byCandle((Block)block));
            level.gameEvent((Entity)player, GameEvent.BLOCK_CHANGE, blockPos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide) {
            if (EnchantedGoldenCakeBlock.eat((LevelAccessor)level, blockPos, blockState, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return EnchantedGoldenCakeBlock.eat((LevelAccessor)level, blockPos, blockState, player);
    }

    @NotNull
    protected static InteractionResult eat(LevelAccessor levelAccessor, @NotNull BlockPos blockPos, BlockState blockState, Player player) {
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(8, 2.4f);
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 1));
        player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 0));
        player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 6000, 0));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 3));
        int currentBites = (Integer)blockState.getValue((Property)BITES);
        levelAccessor.gameEvent((Entity)player, GameEvent.EAT, blockPos);
        if (currentBites < 6) {
            levelAccessor.setBlock(blockPos, (BlockState)blockState.setValue((Property)BITES, (Comparable)Integer.valueOf(currentBites + 1)), 3);
        } else {
            levelAccessor.removeBlock(blockPos, false);
            levelAccessor.gameEvent((Entity)player, GameEvent.BLOCK_DESTROY, blockPos);
        }
        return InteractionResult.SUCCESS;
    }
}

