/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.projectile;

import baguchan.hunters_return.init.HunterDamageSource;
import baguchan.hunters_return.init.HunterEnchantments;
import baguchan.hunters_return.init.HunterEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class BoomerangEntity
extends Projectile {
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCING_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> BOUNCE_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TOUCH_GROUND = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> BOOMERANG = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int totalHits;
    private int flyTick;
    public boolean inGround;
    protected int inGroundTime;
    @Nullable
    private BlockState lastState;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, Level world, LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, world);
        this.m_6034_(shootingEntity.m_20185_(), shootingEntity.m_20188_() - (double)0.1f, shootingEntity.m_20189_());
        this.m_5602_((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)boomerang)));
        this.f_19804_.m_135381_(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)boomerang)));
        this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)HunterEnchantments.BOUNCE.get()), (ItemStack)boomerang)));
        this.totalHits = 0;
        this.setTouchGround(false);
    }

    public BoomerangEntity(Level world, LivingEntity entity, ItemStack boomerang) {
        this((EntityType<? extends BoomerangEntity>)((EntityType)HunterEntityRegistry.BOOMERANG.get()), world, entity, boomerang);
    }

    public DamageSource boomerangAttack(@Nullable Entity p_270857_) {
        return this.m_269291_().m_268998_(HunterDamageSource.BOOMERANG, (Entity)this, p_270857_);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        boolean returnToOwner = false;
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.f_19804_.m_135370_(PIERCING_LEVEL);
        Entity shooter = this.m_19749_();
        if (!(result.m_82443_() == shooter || this.isReturning() && loyaltyLevel > 0)) {
            int sharpness = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.getBoomerang());
            int damage = (int)(3.0 * Math.sqrt(this.m_20184_().m_82553_()) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5 + (double)(0.5f * (float)piercingLevel));
            if (this.m_6060_()) {
                result.m_82443_().m_20254_(5);
            }
            if (damage > 0) {
                result.m_82443_().m_6469_(this.boomerangAttack(shooter), (float)damage);
            }
            if (shooter instanceof LivingEntity) {
                this.getBoomerang().m_41622_(1, (LivingEntity)shooter, p_222182_1_ -> {});
            }
            double speed = this.getSpeed();
            if (piercingLevel < 1 && this.totalHits >= this.getBounceLevel() || this.totalHits >= piercingLevel + this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (piercingLevel < 1 && this.totalHits < this.getBounceLevel() || this.totalHits < piercingLevel + this.getBounceLevel() && speed <= (double)0.4f) {
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                double motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
                this.m_20256_(this.m_20184_().m_82490_((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.m_19749_() != null && this.shouldReturnToThrower() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44955_, (ItemStack)this.getBoomerang()) > 0) {
                this.m_9236_().m_5594_(null, shooter.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.m_9236_().m_5594_(null, shooter.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.m_9236_().m_5594_(null, shooter.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        SoundType soundType = state.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
        byte returnLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        Entity entity = this.m_19749_();
        Vec3 movement = this.m_20184_();
        if (!this.isReturning() || returnLevel > 0 && this.isReturning()) {
            if (movement.m_82553_() < (double)0.2f && movement.f_82480_ <= 0.0) {
                if (returnLevel > 0) {
                    if (!this.isReturning() && entity != null) {
                        this.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        this.setReturning(true);
                    }
                } else {
                    this.setReturning(false);
                    this.inGround = true;
                    this.lastState = this.m_9236_().m_8055_(result.m_82425_());
                    Vec3 vec3 = result.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_20256_(vec3);
                    Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
                    this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
                }
            } else {
                Vec3i direction = result.m_82434_().m_122436_();
                switch (result.m_82434_()) {
                    case UP: 
                    case SOUTH: 
                    case EAST: {
                        direction = direction.m_142393_(-1);
                        break;
                    }
                }
                direction = new Vec3i(direction.m_123341_() == 0 ? 1 : direction.m_123341_(), direction.m_123342_() == 0 ? 1 : direction.m_123342_(), direction.m_123343_() == 0 ? 1 : direction.m_123343_());
                this.m_20256_(movement.m_82559_(new Vec3((double)direction.m_123341_(), (double)direction.m_123342_(), (double)direction.m_123343_())).m_82490_((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
                this.m_5496_(SoundEvents.f_12638_, 0.5f, 1.0f);
                if (!this.isReturning()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundType.m_56778_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
                }
                if (returnLevel <= 0) {
                    this.setTouchGround(true);
                    this.setReturning(false);
                }
            }
        }
    }

    public int getFlyTick() {
        return this.flyTick;
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !entity.m_5833_();
        }
        return false;
    }

    private boolean shouldDropToThrower() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !entity.m_5833_() && !(entity instanceof Player) && this.m_20280_(entity) < 3.0;
        }
        return false;
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        if (this.flyTick >= 10 && entityIn == this.m_19749_() && !this.m_9236_().f_46443_ && (!entityIn.m_7500_() && this.tryPickup(entityIn) || entityIn.m_7500_())) {
            this.m_216990_(SoundEvents.f_12019_);
            entityIn.m_7938_((Entity)this, 1);
            this.m_146870_();
        }
    }

    protected boolean tryPickup(Player p_150121_) {
        return p_150121_.m_150109_().m_36054_(this.getBoomerang());
    }

    public void drop(double x, double y, double z) {
        if (!this.m_9236_().m_5776_()) {
            if (!(this.m_19749_() instanceof Player) || this.m_19749_() instanceof Player && !((Player)this.m_19749_()).m_7500_()) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), x, y, z, this.getBoomerang().m_41620_(1)));
                this.m_146870_();
            } else {
                this.m_146870_();
            }
        }
    }

    public void m_6478_(MoverType p_36749_, Vec3 p_36750_) {
        super.m_6478_(p_36749_, p_36750_);
        if (p_36749_ != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void m_6686_(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        super.m_6686_(p_36775_, p_36776_, p_36777_, p_36778_, p_36779_);
        this.inGroundTime = 0;
    }

    public void m_6453_(double p_36728_, double p_36729_, double p_36730_, float p_36731_, float p_36732_, int p_36733_, boolean p_36734_) {
        this.m_6034_(p_36728_, p_36729_, p_36730_);
        this.m_19915_(p_36731_, p_36732_);
    }

    public void m_6001_(double p_36786_, double p_36787_, double p_36788_) {
        super.m_6001_(p_36786_, p_36787_, p_36788_);
        this.inGroundTime = 0;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        byte returningLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        boolean flag = false;
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 180.0 / 3.1415927410125732));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 180.0 / 3.1415927410125732));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || returningLevel > 0 || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.m_20095_();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.m_9236_().f_46443_) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            Entity entity = this.m_19749_();
            if (!this.isReturning() && this.flyTick >= 30 && entity != null) {
                this.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setReturning(true);
            }
            if (entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
                this.drop(this.m_20185_(), this.m_20186_(), this.m_20189_());
            } else if (entity != null && this.isReturning()) {
                this.f_19794_ = true;
                Vec3 vec3d3 = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                double d0 = 0.05 * (double)(returningLevel + 1);
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3d3.m_82541_().m_82490_(d0)));
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 180.0 / 3.1415927410125732));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 180.0 / 3.1415927410125732));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 180.0 / 3.1415927410125732));
            this.m_146926_(BoomerangEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(BoomerangEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 1.0f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f1 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.getWaterInertia();
            }
            if (!flag) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - (double)this.getGravity(), this.m_20184_().f_82481_);
            }
            this.m_20256_(this.m_20184_().m_82490_((double)f));
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
            if (!this.m_9236_().m_5776_() && returningLevel > 0) {
                List list = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), this.m_20191_().m_82400_((double)0.1f), Entity::m_6084_);
                if (this.m_20197_().isEmpty() && list != null && !list.isEmpty()) {
                    ((ItemEntity)list.get(0)).m_20329_((Entity)this);
                }
            }
            ++this.flyTick;
        }
        if (this.shouldDropToThrower()) {
            this.drop(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    private float getWaterInertia() {
        return 0.6f;
    }

    protected void tickDespawn() {
        ++this.inGroundTime;
        if (this.inGroundTime >= 1200) {
            this.m_146870_();
        }
    }

    private boolean shouldFall() {
        return this.isInGround() && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.setInGround(false);
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
        this.inGroundTime = 0;
    }

    protected float getGravity() {
        if (this.getLoyaltyLevel() > 0 && !this.isReturning()) {
            if (this.m_20069_()) {
                return 0.01f;
            }
            return 0.0f;
        }
        return this.getLoyaltyLevel() <= 0 && this.isTouchGround() ? 0.05f : 0.0f;
    }

    public boolean m_6783_(double p_70112_1_) {
        double d0 = this.m_20191_().m_82309_() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(PIERCING_LEVEL, (Object)0);
        this.f_19804_.m_135372_(BOUNCE_LEVEL, (Object)0);
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(TOUCH_GROUND, (Object)true);
        this.f_19804_.m_135372_(BOOMERANG, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("boomerang", (Tag)this.getBoomerang().m_41739_(new CompoundTag()));
        nbt.m_128405_("totalHits", this.totalHits);
        nbt.m_128405_("InGroundTime", this.inGroundTime);
        nbt.m_128405_("FlyTick", this.flyTick);
        nbt.m_128379_("returning", this.isReturning());
        if (this.lastState != null) {
            nbt.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
        nbt.m_128379_("inGround", this.isInGround());
        nbt.m_128379_("TouchGround", this.isTouchGround());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setBoomerang(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("boomerang")));
        this.totalHits = nbt.m_128451_("totalHits");
        this.inGroundTime = nbt.m_128451_("InGroundTime");
        if (nbt.m_128425_("inBlockState", 10)) {
            this.lastState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("inBlockState"));
        }
        this.setInGround(nbt.m_128471_("inGround"));
        this.flyTick = nbt.m_128451_("FlyTick");
        this.setReturning(nbt.m_128471_("returning"));
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.getBoomerang())));
        this.f_19804_.m_135381_(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)this.getBoomerang())));
        this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)HunterEnchantments.BOUNCE.get()), (ItemStack)this.getBoomerang())));
        this.setTouchGround(nbt.m_128471_("TouchGround"));
    }

    private int getLoyaltyLevel() {
        return ((Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL)).byteValue();
    }

    public int getInGroundTime() {
        return this.inGroundTime;
    }

    private int getBounceLevel() {
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        byte bounceLevel = (Byte)this.f_19804_.m_135370_(BOUNCE_LEVEL);
        if (loyaltyLevel > 0) {
            return bounceLevel * 2;
        }
        return bounceLevel;
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.f_19804_.m_135370_(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82480_ * this.m_20184_().f_82480_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
    }

    public double getVelocity() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
    }

    public int getPiercingLevel() {
        return ((Byte)this.f_19804_.m_135370_(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(RETURNING, (Object)returning);
    }

    public void setInGround(boolean flag) {
        this.inGround = flag;
    }

    public boolean isInGround() {
        return this.inGround;
    }

    public void setBoomerang(ItemStack stack) {
        this.f_19804_.m_135381_(BOOMERANG, (Object)stack);
    }

    public void setTouchGround(boolean flag) {
        this.f_19804_.m_135381_(TOUCH_GROUND, (Object)flag);
    }

    public boolean isTouchGround() {
        return (Boolean)this.f_19804_.m_135370_(TOUCH_GROUND);
    }
}

