/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.ai;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MiniCrossBowAttackGoal<T extends Mob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public <M extends Monster> MiniCrossBowAttackGoal(M p_25814_, double p_25815_, float p_25816_) {
        this(p_25814_, p_25815_, p_25816_);
    }

    public MiniCrossBowAttackGoal(T p_25814_, double p_25815_, float p_25816_) {
        this.mob = p_25814_;
        this.speedModifier = p_25815_;
        this.attackRadiusSqr = p_25816_ * p_25816_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        InteractionHand hand2 = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem) == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.75);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.mob).m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.mob.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.mob.m_21252_()) >= (itemstack = this.mob.m_21211_()).m_41779_()) {
                    this.mob.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 12 + this.mob.m_217043_().m_188503_(4);
                    ((CrossbowAttackMob)this.mob).m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                ((CrossbowAttackMob)this.mob).m_32336_(this.mob, 1.2f);
                ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                Item item2 = this.mob.m_21120_(hand2).m_41720_();
                if (item2 instanceof CrossbowItem) {
                    CrossbowItem miniCrossBowItem = (CrossbowItem)item2;
                    this.attackDelay = 8;
                    this.crossbowState = CrossbowState.READY_TO_ATTACK_SECOND;
                } else {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK_SECOND && flag) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.performSecondCrossbowAttack((LivingEntity)this.mob, hand2, 1.2f);
                    CrossbowItem.m_40884_((ItemStack)this.mob.m_21120_(hand2), (boolean)false);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }
    }

    protected void performSecondCrossbowAttack(LivingEntity p_32337_, InteractionHand hand, float p_32338_) {
        ItemStack itemstack = p_32337_.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof CrossbowItem) {
            CrossbowItem crossbowitem = (CrossbowItem)item;
            CrossbowItem.m_40887_((Level)p_32337_.m_9236_(), (LivingEntity)p_32337_, (InteractionHand)hand, (ItemStack)itemstack, (float)p_32338_, (float)(14 - p_32337_.m_9236_().m_46791_().m_19028_() * 4));
        }
        ((CrossbowAttackMob)this.mob).m_5847_();
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK,
        READY_TO_ATTACK_SECOND;

    }
}

