/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.BlacklistCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.HideTickCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.PositionsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.RotationsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ScaleCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SlotAttachmentCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SlotMoverCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ToggleCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.UniqueItemSettingsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.WhitelistCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class GetServerConfigSettingsSPacket {
    public GetServerConfigSettingsSPacket(FriendlyByteBuf buf) {
    }

    public GetServerConfigSettingsSPacket() {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerData data;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!sender.m_9236_().m_5776_() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
                int i;
                if (ConfigHolder.COMMON.positions != null) {
                    for (i = 0; i < ConfigHolder.COMMON.positions.length; ++i) {
                        data.positions[i] = (Integer)ConfigHolder.COMMON.positions[i].get();
                    }
                }
                if (ConfigHolder.COMMON.rotations != null) {
                    for (i = 0; i < ConfigHolder.COMMON.rotations.length; ++i) {
                        data.rotations[i] = (Integer)ConfigHolder.COMMON.rotations[i].get();
                    }
                }
                if (ConfigHolder.COMMON.scale != null) {
                    for (i = 0; i < ConfigHolder.COMMON.scale.length; ++i) {
                        data.scale[i] = (Integer)ConfigHolder.COMMON.scale[i].get();
                    }
                }
                if (ConfigHolder.COMMON.TOGGLE_SLOT_MODEL != null) {
                    for (i = 0; i < ConfigHolder.COMMON.TOGGLE_SLOT_MODEL.length; ++i) {
                        data.toggleSlots[i] = (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[i].get() != false ? 1 : 0;
                    }
                }
                if (ConfigHolder.COMMON.hideTick != null) {
                    data.hideTick = (Integer)ConfigHolder.COMMON.hideTick.get();
                }
                if (ModUtils.stringExist((String)ConfigHolder.COMMON.slot_attachment.get())) {
                    data.slotAttachments = (String)ConfigHolder.COMMON.slot_attachment.get();
                }
                if (ModUtils.stringExist((String)ConfigHolder.COMMON.slotMover.get())) {
                    data.mover = (String)ConfigHolder.COMMON.slotMover.get();
                }
                if (ModUtils.stringExist((String)ConfigHolder.COMMON.blacklist.get())) {
                    data.blacklist = (String)ConfigHolder.COMMON.blacklist.get();
                }
                if (ModUtils.stringExist((String)ConfigHolder.COMMON.whitelist.get())) {
                    data.whitelist = (String)ConfigHolder.COMMON.whitelist.get();
                }
                if (ModUtils.stringExist((String)ConfigHolder.COMMON.uniqueItemDisplay.get())) {
                    data.uniqueItemDisplay = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
                }
                for (Player sp : ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_6907_()) {
                    if (!(sp.m_20280_((Entity)sender) < 4000.0)) continue;
                    Networking.sendToClient(new PositionsCPacket(data.positions, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new RotationsCPacket(data.rotations, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new ScaleCPacket(data.scale, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new ToggleCPacket(data.toggleSlots, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new HideTickCPacket(data.hideTick, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new SlotAttachmentCPacket(data.slotAttachments, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new SlotMoverCPacket(data.mover, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new BlacklistCPacket(data.blacklist, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new WhitelistCPacket(data.whitelist, true, sender.m_20148_()), (ServerPlayer)sp);
                    Networking.sendToClient(new UniqueItemSettingsCPacket(data.uniqueItemDisplay, true, sender.m_20148_()), (ServerPlayer)sp);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

