/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.reg;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.common.LecternEditMenu;
import net.mehvahdjukaar.amendments.common.block.CarpetSlabBlock;
import net.mehvahdjukaar.amendments.common.block.CarpetStairBlock;
import net.mehvahdjukaar.amendments.common.block.CeilingBannerBlock;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.mehvahdjukaar.amendments.common.block.DoubleCakeBlock;
import net.mehvahdjukaar.amendments.common.block.DoubleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.FloorCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.HangingFlowerPotBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ToolHookBlock;
import net.mehvahdjukaar.amendments.common.block.WallCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.common.block.WaterloggedLilyBlock;
import net.mehvahdjukaar.amendments.common.entity.FallingLanternEntity;
import net.mehvahdjukaar.amendments.common.entity.MediumDragonFireball;
import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.common.entity.RingEffectCloud;
import net.mehvahdjukaar.amendments.common.item.DragonChargeItem;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.item.placement.WallLanternPlacement;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.DyeBottleRecipe;
import net.mehvahdjukaar.amendments.common.tile.CandleSkullBlockTile;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.common.tile.CeilingBannerBlockTile;
import net.mehvahdjukaar.amendments.common.tile.DoubleSkullBlockTile;
import net.mehvahdjukaar.amendments.common.tile.HangingFlowerPotBlockTile;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.common.tile.ToolHookBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WaterloggedLilyBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.DynamicHolder;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.Util;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;

public class ModRegistry {
    public static final DynamicHolder<DamageType> BOILING_DAMAGE = DynamicHolder.of((ResourceLocation)Amendments.res("boiling"), (ResourceKey)Registries.f_268580_);
    public static final DynamicHolder<SoftFluid> DYE_SOFT_FLUID = DynamicHolder.of((ResourceLocation)Amendments.res("dye"), (ResourceKey)SoftFluidRegistry.KEY);
    public static final RegSupplier<RecipeSerializer<DyeBottleRecipe>> DYE_BOTTLE_RECIPE = RegHelper.registerSpecialRecipe((ResourceLocation)Amendments.res("dye_bottle"), DyeBottleRecipe::new);
    public static final Supplier<MenuType<LecternEditMenu>> LECTERN_EDIT_MENU = RegHelper.registerMenuType((ResourceLocation)Amendments.res("lectern_edit"), LecternEditMenu::new);
    public static final RegSupplier<SimpleParticleType> BOILING_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("boiling_bubble"));
    public static final RegSupplier<SimpleParticleType> SPLASH_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fluid_splash"));
    public static final Supplier<SimpleParticleType> DRAGON_FIREBALL_TRAIL_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("dragon_fireball_trail"));
    public static final Supplier<SimpleParticleType> FIREBALL_TRAIL_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_trail"));
    public static final Supplier<SimpleParticleType> FIREBALL_EMITTER_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_explosion_emitter"));
    public static final Supplier<SimpleParticleType> FIREBALL_EXPLOSION_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_explosion"));
    public static final Supplier<SoundEvent> FIREBALL_EXPLOSION_SOUND = RegHelper.registerSound((ResourceLocation)Amendments.res("explosion.fireball"));
    public static final Supplier<RecipeType<CauldronRecipe>> CAULDRON_RECIPE_TYPE = RegHelper.registerRecipeType((ResourceLocation)Amendments.res("cauldron_crafting"));
    public static final Supplier<RecipeSerializer<CauldronRecipe>> CAULDRON_RECIPE_SERIALIZER = RegHelper.registerRecipeSerializer((ResourceLocation)Amendments.res("cauldron_crafting"), CauldronRecipe.Serializer::new);
    public static final Supplier<EntityType<MediumDragonFireball>> MEDIUM_DRAGON_FIREBALL = RegHelper.registerEntityType((ResourceLocation)Amendments.res("medium_dragon_fireball"), () -> EntityType.Builder.m_20704_(MediumDragonFireball::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(16).m_20717_(5).m_20712_("medium_dragon_fireball"));
    public static final Supplier<EntityType<MediumFireball>> MEDIUM_FIREBALL = RegHelper.registerEntityType((ResourceLocation)Amendments.res("medium_fireball"), () -> EntityType.Builder.m_20704_(MediumFireball::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(16).m_20717_(5).m_20712_("medium_fireball"));
    public static final Supplier<EntityType<RingEffectCloud>> RING_EFFECT_CLOUD = RegHelper.registerEntityType((ResourceLocation)Amendments.res("ring_effect_cloud"), () -> EntityType.Builder.m_20704_(RingEffectCloud::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(6.0f, 0.5f).m_20702_(10).m_20717_(Integer.MAX_VALUE).m_20712_("ring_effect_cloud"));
    public static final Supplier<Item> DRAGON_CHARGE = ModRegistry.regItem("dragon_charge", () -> new DragonChargeItem(new Item.Properties()));
    public static final Supplier<Item> DYE_BOTTLE_ITEM = ModRegistry.regItem("dye_bottle", () -> new DyeBottleItem(new Item.Properties().m_41487_(1).m_41495_(Items.f_42590_)));
    public static final Supplier<Block> WATERLILY_BLOCK = ModRegistry.regBlock("water_lily_pad", () -> new WaterloggedLilyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50196_).m_60966_().m_60918_(SoundType.f_56741_).m_60955_()));
    public static final Supplier<BlockEntityType<WaterloggedLilyBlockTile>> WATERLILY_TILE = ModRegistry.regTile("water_lily_pad", () -> PlatHelper.newBlockEntityType(WaterloggedLilyBlockTile::new, (Block[])new Block[]{WATERLILY_BLOCK.get()}));
    public static final Supplier<LiquidCauldronBlock> LIQUID_CAULDRON = ModRegistry.regBlock("liquid_cauldron", () -> new LiquidCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_)));
    public static final Supplier<Block> DYE_CAULDRON = ModRegistry.regBlock("dye_cauldron", () -> new DyeCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_)));
    public static final Supplier<BlockEntityType<LiquidCauldronBlockTile>> LIQUID_CAULDRON_TILE = ModRegistry.regTile("liquid_cauldron", () -> PlatHelper.newBlockEntityType(LiquidCauldronBlockTile::new, (Block[])new Block[]{(Block)LIQUID_CAULDRON.get(), DYE_CAULDRON.get()}));
    public static final Supplier<Block> HANGING_FLOWER_POT = ModRegistry.regBlock("hanging_flower_pot", () -> new HangingFlowerPotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final Supplier<BlockEntityType<HangingFlowerPotBlockTile>> HANGING_FLOWER_POT_TILE = ModRegistry.regTile("hanging_flower_pot", () -> PlatHelper.newBlockEntityType(HangingFlowerPotBlockTile::new, (Block[])new Block[]{HANGING_FLOWER_POT.get()}));
    public static final Map<DyeColor, Supplier<Block>> CEILING_BANNERS = (Map)Util.m_137537_(() -> {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = "ceiling_banner_" + color.m_41065_();
            map.put(color, ModRegistry.regBlock(name, () -> new CeilingBannerBlock(color, BlockBehaviour.Properties.m_284310_().m_278183_().m_280606_().m_284180_(color.m_284406_()).m_60978_(1.0f).m_60910_().m_60918_(SoundType.f_56736_))));
        }
        return Collections.unmodifiableMap(map);
    });
    public static final Supplier<BlockEntityType<CeilingBannerBlockTile>> CEILING_BANNER_TILE = ModRegistry.regTile("ceiling_banner", () -> PlatHelper.newBlockEntityType(CeilingBannerBlockTile::new, (Block[])((Block[])CEILING_BANNERS.values().stream().map(Supplier::get).toArray(Block[]::new))));
    public static final Supplier<Block> CARPET_STAIRS = ModRegistry.regBlock("carpet_stairs", () -> new CarpetStairBlock(Blocks.f_50086_));
    public static final Supplier<Block> CARPET_SLAB = ModRegistry.regBlock("carpet_slab", () -> new CarpetSlabBlock(Blocks.f_50398_));
    public static final Supplier<BlockEntityType<CarpetedBlockTile>> CARPET_STAIRS_TILE = ModRegistry.regTile("carpeted_block", () -> PlatHelper.newBlockEntityType(CarpetedBlockTile::new, (Block[])new Block[]{CARPET_STAIRS.get(), CARPET_SLAB.get()}));
    public static final Supplier<WallLanternBlock> WALL_LANTERN = ModRegistry.regBlock("wall_lantern", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_278166_(PushReaction.DESTROY).m_60953_(state -> 15).m_222994_();
        return new WallLanternBlock(p);
    });
    public static final Supplier<BlockEntityType<WallLanternBlockTile>> WALL_LANTERN_TILE = ModRegistry.regTile("wall_lantern", () -> PlatHelper.newBlockEntityType(WallLanternBlockTile::new, (Block[])new Block[]{(Block)WALL_LANTERN.get()}));
    public static final Supplier<EntityType<FallingLanternEntity>> FALLING_LANTERN = ModRegistry.regEntity("falling_lantern", () -> EntityType.Builder.m_20704_(FallingLanternEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.98f).m_20702_(10).m_20717_(20));
    public static final Supplier<ToolHookBlock> TOOL_HOOK = ModRegistry.regBlock("tool_hook", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50266_).m_60916_(Blocks.f_50266_);
        return new ToolHookBlock(p);
    });
    public static final Supplier<BlockEntityType<ToolHookBlockTile>> TOOL_HOOK_TILE = ModRegistry.regTile("tool_hook", () -> PlatHelper.newBlockEntityType(ToolHookBlockTile::new, (Block[])new Block[]{TOOL_HOOK.get()}));
    public static final Supplier<Block> SKULL_PILE = ModRegistry.regBlock("skull_pile", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50310_).m_60918_(SoundType.f_56724_);
        return new DoubleSkullBlock(p);
    });
    public static final Supplier<BlockEntityType<DoubleSkullBlockTile>> SKULL_PILE_TILE = ModRegistry.regTile("skull_pile", () -> PlatHelper.newBlockEntityType(DoubleSkullBlockTile::new, (Block[])new Block[]{SKULL_PILE.get()}));
    public static final Supplier<Block> SKULL_CANDLE = ModRegistry.regBlock("skull_candle", () -> new FloorCandleSkullBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50310_).m_60918_(SoundType.f_56724_)));
    public static final Supplier<Block> SKULL_CANDLE_WALL = ModRegistry.regBlock("skull_candle_wall", () -> new WallCandleSkullBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<Block> SKULL_CANDLE_SOUL = ModRegistry.regBlock("skull_candle_soul", () -> new FloorCandleSkullBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<Block> SKULL_CANDLE_SOUL_WALL = ModRegistry.regBlock("skull_candle_soul_wall", () -> new WallCandleSkullBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<BlockEntityType<CandleSkullBlockTile>> SKULL_CANDLE_TILE = ModRegistry.regTile("skull_candle", () -> PlatHelper.newBlockEntityType(CandleSkullBlockTile::new, (Block[])new Block[]{SKULL_CANDLE.get(), SKULL_CANDLE_WALL.get(), SKULL_CANDLE_SOUL.get(), SKULL_CANDLE_SOUL_WALL.get()}));
    public static final Supplier<Block> DIRECTIONAL_CAKE = ModRegistry.regBlock("directional_cake", () -> new DirectionalCakeBlock(CakeRegistry.VANILLA));
    public static final Map<CakeRegistry.CakeType, DoubleCakeBlock> DOUBLE_CAKES = new LinkedHashMap<CakeRegistry.CakeType, DoubleCakeBlock>();

    public static void init() {
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)CakeRegistry.INSTANCE);
        BlockSetAPI.addDynamicBlockRegistration(ModRegistry::registerDoubleCakes, CakeRegistry.CakeType.class);
        AdditionalItemPlacementsAPI.addRegistration(ModRegistry::registerAdditionalPlacements);
    }

    public static void registerAdditionalPlacements(AdditionalItemPlacementsAPI.Event event) {
        WallLanternPlacement wallLanternPlacement = new WallLanternPlacement();
        for (Item i : BuiltInRegistries.f_257033_) {
            if (!(i instanceof BlockItem)) continue;
            BlockItem bi = (BlockItem)i;
            Block block = bi.m_40614_();
            Preconditions.checkNotNull((Object)block, (Object)("BlockItem " + String.valueOf(i) + " has a NULL block! This is not an amendments issue and its likely caused by some bigger underlying issue"));
            if (!CommonConfigs.WALL_LANTERN.get().booleanValue() || !WallLanternBlock.isValidBlock(block)) continue;
            event.register(i, (AdditionalItemPlacement)wallLanternPlacement);
        }
        if (CommonConfigs.HANGING_POT.get().booleanValue()) {
            event.registerSimple(Items.f_42618_, HANGING_FLOWER_POT.get());
        }
        if (CommonConfigs.CEILING_BANNERS.get().booleanValue()) {
            for (Map.Entry<DyeColor, Supplier<Block>> e : CEILING_BANNERS.entrySet()) {
                event.registerSimple((Item)Preconditions.checkNotNull((Object)BannerBlock.m_49014_((DyeColor)e.getKey()).m_5456_()), e.getValue().get());
            }
        }
    }

    private static void registerDoubleCakes(Registrator<Block> event, Collection<CakeRegistry.CakeType> cakes) {
        for (CakeRegistry.CakeType type : cakes) {
            ResourceLocation id = Amendments.res(type.getVariantId("double"));
            DoubleCakeBlock block = new DoubleCakeBlock(type);
            type.addChild("double_cake", (Object)block);
            event.register(id, (Object)block);
            DOUBLE_CAKES.put(type, block);
        }
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Item> RegSupplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, Supplier<EntityType.Builder<T>> builder) {
        return RegHelper.registerEntityType((ResourceLocation)Amendments.res(name), () -> ((EntityType.Builder)builder.get()).m_20712_(name));
    }
}

