/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.entity.MediumDragonFireball;
import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.events.dispenser.CauldronDispenserBehavior;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Amendments {
    public static final String MOD_ID = "amendments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Amendments");
    public static final List<String> OLD_MODS = List.of("supplementaries", "carpeted", "betterlily", "betterjukebox");

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void init() {
        CommonConfigs.init();
        ModRegistry.init();
        ModNetwork.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            AmendmentsClient.init();
        }
        PlatHelper.addCommonSetupAsync(Amendments::setupAsync);
        PlatHelper.addCommonSetup(Amendments::setup);
        PlatHelper.addReloadableCommonSetup(Amendments::onReload);
        RegHelper.addDynamicDispenserBehaviorRegistration(Amendments::registerDispenserBehavior);
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)Amendments.res("flag"), CommonConfigs::isFlagOn);
        RegHelper.addItemsToTabsRegistration(Amendments::addItemsToTabs);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent itemToTabEvent) {
        if (CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            itemToTabEvent.addBefore(CreativeModeTabs.f_256797_, i -> i.m_150930_(Items.f_42452_), new ItemLike[]{Items.f_42613_});
            if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
                itemToTabEvent.addBefore(CreativeModeTabs.f_256797_, i -> i.m_150930_(Items.f_42452_), new ItemLike[]{(ItemLike)ModRegistry.DRAGON_CHARGE.get()});
            }
        }
    }

    private static void setup() {
        if (CommonConfigs.INVERSE_POTIONS.get() == null) {
            throw new IllegalStateException("Inverse potions config is null. How??");
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.setup();
        }
    }

    private static void setupAsync() {
        FlowerPotHandler.setup();
        ClientConfigs.setup();
    }

    public static void onReload(RegistryAccess registryAccess, boolean client) {
        InteractEvents.setupOverrides();
        if (client) {
            AmendmentsClient.afterTagSetup();
        }
    }

    private static void registerDispenserBehavior(DispenserHelper.Event event) {
        for (SoftFluid f : SoftFluidRegistry.getRegistry((RegistryAccess)event.getRegistryAccess())) {
            Amendments.registerFluidBehavior(f, event);
        }
        if (CommonConfigs.FIRE_CHARGE_DISPENSER.get().booleanValue() && CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            event.register(Items.f_42613_, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected MediumFireball getProjectile(Level level, Position position, ItemStack stack) {
                    return (MediumFireball)Util.m_137469_((Object)new MediumFireball(level, position.m_7096_(), position.m_7098_(), position.m_7094_()), snowball -> snowball.m_37446_(stack));
                }

                protected void m_6823_(BlockSource source) {
                    source.m_7727_().m_46796_(1018, source.m_7961_(), 0);
                }
            });
        }
        if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
            event.register(ModRegistry.DRAGON_CHARGE.get(), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected MediumDragonFireball getProjectile(Level level, Position position, ItemStack stack) {
                    return (MediumDragonFireball)Util.m_137469_((Object)new MediumDragonFireball(level, position.m_7096_(), position.m_7098_(), position.m_7094_()), snowball -> snowball.m_37446_(stack));
                }

                protected void m_6823_(BlockSource source) {
                    source.m_7727_().m_46796_(1018, source.m_7961_(), 0);
                }
            });
        }
    }

    public static void registerFluidBehavior(SoftFluid f, DispenserHelper.Event event) {
        HashSet<Item> itemSet = new HashSet<Item>();
        Collection categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            for (Item full : c.getFilledItems()) {
                if (full == Items.f_41852_ || itemSet.contains(full)) continue;
                event.register((DispenserHelper.AdditionalDispenserBehavior)new CauldronDispenserBehavior(full));
                itemSet.add(full);
            }
        }
    }

    public static boolean isSupportingCeiling(BlockPos pos, LevelReader world) {
        return Amendments.isSupportingCeiling(world.m_8055_(pos), pos, world);
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isSupportingCeiling(upState, pos, world);
        }
        return Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN);
    }

    public static boolean canConnectDown(BlockState neighborState, LevelAccessor level, BlockPos pos) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.canConnectDown(neighborState);
        }
        return neighborState.m_60659_((BlockGetter)level, pos, Direction.UP, SupportType.CENTER);
    }
}

