/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.core.generator.RecipeGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CGRecipeGenerator
extends RecipeGenerator {
    private Block vanillaBlock;
    private final List<Block> vanillaBlocks = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredBlocks = new EnumMap(DyeColor.class);
    private Block vanillaPane;
    private final List<Block> vanillaPanes = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredPanes = new EnumMap(DyeColor.class);

    public CGRecipeGenerator(ResourceCache cache) {
        super("connectedglass", cache);
    }

    public void generate() {
        Object previous;
        this.gatherVanillaBlocks();
        this.gatherVanillaPanes();
        CGGlassType lastType = null;
        CGGlassType lastTypeTinted = null;
        for (CGGlassType type : CGGlassType.values()) {
            DyeColor color;
            for (CGGlassBlock cGGlassBlock : type.blocks) {
                DyeColor dyeColor = color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).m_7988_() : null;
                Object previous2 = type.isTinted ? (lastTypeTinted == null ? (color == null ? Blocks.f_152498_ : null) : lastTypeTinted.getBlock(color)) : (lastType == null ? this.getVanillaBlock(color) : lastType.getBlock(color));
                if (previous2 == null) continue;
                this.shaped(Registries.BLOCKS.getIdentifier((Object)cGGlassBlock).m_135815_() + "1", (ItemLike)cGGlassBlock, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous2}).unlockedBy(new ItemLike[]{previous2});
            }
            for (CGColoredGlassBlock cGColoredGlassBlock : type.colored_blocks.values()) {
                ((RecipeGenerator.ShapedRecipeBuilder)this.shaped(Registries.BLOCKS.getIdentifier((Object)cGColoredGlassBlock).m_135815_() + "2", (ItemLike)cGColoredGlassBlock, 8).pattern("AAA").pattern("ABA").pattern("AAA").input('A', new ItemLike[]{type.block}).input('B', cGColoredGlassBlock.m_7988_().getTag()).unlockedBy(new ItemLike[]{type.block})).unlockedBy(cGColoredGlassBlock.m_7988_().getTag());
            }
            if (type.hasPanes) {
                for (CGPaneBlock cGPaneBlock : type.panes) {
                    DyeColor dyeColor = color = cGPaneBlock instanceof CGColoredPaneBlock ? ((CGColoredPaneBlock)cGPaneBlock).m_7988_() : null;
                    Object previous2 = type.isTinted ? (lastTypeTinted == null ? null : lastTypeTinted.getPane(color)) : (lastType == null ? this.getVanillaPane(color) : lastType.getPane(color));
                    if (previous2 == null) continue;
                    this.shaped(Registries.BLOCKS.getIdentifier((Object)cGPaneBlock).m_135815_() + "1", (ItemLike)cGPaneBlock, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous2}).unlockedBy(new ItemLike[]{previous2});
                }
                for (CGColoredPaneBlock cGColoredPaneBlock : type.colored_panes.values()) {
                    ((RecipeGenerator.ShapedRecipeBuilder)this.shaped(Registries.BLOCKS.getIdentifier((Object)cGColoredPaneBlock).m_135815_() + "2", (ItemLike)cGColoredPaneBlock, 8).pattern("AAA").pattern("ABA").pattern("AAA").input('A', new ItemLike[]{type.pane}).input('B', cGColoredPaneBlock.m_7988_().getTag()).unlockedBy(new ItemLike[]{type.pane})).unlockedBy(cGColoredPaneBlock.m_7988_().getTag());
                }
                for (CGGlassBlock cGGlassBlock : type.blocks) {
                    color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).m_7988_() : null;
                    CGPaneBlock pane = type.getPane(color);
                    this.shaped(Registries.BLOCKS.getIdentifier((Object)pane).m_135815_() + "3", (ItemLike)pane, 16).pattern("AAA").pattern("AAA").input('A', new ItemLike[]{cGGlassBlock}).unlockedBy(new ItemLike[]{cGGlassBlock});
                }
            }
            if (type.isTinted) {
                lastTypeTinted = type;
                continue;
            }
            lastType = type;
        }
        for (Block block : this.vanillaBlocks) {
            DyeColor color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).m_7988_() : null;
            previous = lastType.getBlock(color);
            this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)block).m_135815_(), (ItemLike)block, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous}).unlockedBy(new ItemLike[]{previous});
        }
        for (Block pane : this.vanillaPanes) {
            DyeColor color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).m_7988_() : null;
            previous = lastType.getPane(color);
            this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)pane).m_135815_(), (ItemLike)pane, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous}).unlockedBy(new ItemLike[]{previous});
        }
        CGGlassBlock previous3 = lastTypeTinted.getBlock(null);
        this.shaped("vanilla_" + Registries.BLOCKS.getIdentifier((Object)Blocks.f_152498_).m_135815_(), (ItemLike)Blocks.f_152498_, 4).pattern("AA").pattern("AA").input('A', new ItemLike[]{previous3}).unlockedBy(new ItemLike[]{previous3});
    }

    private void gatherVanillaBlocks() {
        this.addVanillaBlock(Blocks.f_50058_);
        this.addVanillaBlock(Blocks.f_50147_);
        this.addVanillaBlock(Blocks.f_50148_);
        this.addVanillaBlock(Blocks.f_50202_);
        this.addVanillaBlock(Blocks.f_50203_);
        this.addVanillaBlock(Blocks.f_50204_);
        this.addVanillaBlock(Blocks.f_50205_);
        this.addVanillaBlock(Blocks.f_50206_);
        this.addVanillaBlock(Blocks.f_50207_);
        this.addVanillaBlock(Blocks.f_50208_);
        this.addVanillaBlock(Blocks.f_50209_);
        this.addVanillaBlock(Blocks.f_50210_);
        this.addVanillaBlock(Blocks.f_50211_);
        this.addVanillaBlock(Blocks.f_50212_);
        this.addVanillaBlock(Blocks.f_50213_);
        this.addVanillaBlock(Blocks.f_50214_);
        this.addVanillaBlock(Blocks.f_50215_);
    }

    private void addVanillaBlock(Block block) {
        DyeColor color;
        this.vanillaBlocks.add(block);
        DyeColor dyeColor = color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).m_7988_() : null;
        if (color == null) {
            this.vanillaBlock = block;
        } else {
            this.vanillaColoredBlocks.put(color, block);
        }
    }

    private void gatherVanillaPanes() {
        this.addVanillaPane(Blocks.f_50185_);
        this.addVanillaPane(Blocks.f_50303_);
        this.addVanillaPane(Blocks.f_50304_);
        this.addVanillaPane(Blocks.f_50305_);
        this.addVanillaPane(Blocks.f_50306_);
        this.addVanillaPane(Blocks.f_50307_);
        this.addVanillaPane(Blocks.f_50361_);
        this.addVanillaPane(Blocks.f_50362_);
        this.addVanillaPane(Blocks.f_50363_);
        this.addVanillaPane(Blocks.f_50364_);
        this.addVanillaPane(Blocks.f_50365_);
        this.addVanillaPane(Blocks.f_50366_);
        this.addVanillaPane(Blocks.f_50367_);
        this.addVanillaPane(Blocks.f_50368_);
        this.addVanillaPane(Blocks.f_50369_);
        this.addVanillaPane(Blocks.f_50370_);
        this.addVanillaPane(Blocks.f_50371_);
    }

    private void addVanillaPane(Block pane) {
        DyeColor color;
        this.vanillaPanes.add(pane);
        DyeColor dyeColor = color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).m_7988_() : null;
        if (color == null) {
            this.vanillaPane = pane;
        } else {
            this.vanillaColoredPanes.put(color, pane);
        }
    }

    private Block getVanillaBlock(DyeColor color) {
        if (color == null) {
            return this.vanillaBlock;
        }
        return this.vanillaColoredBlocks.get(color);
    }

    private Block getVanillaPane(DyeColor color) {
        if (color == null) {
            return this.vanillaPane;
        }
        return this.vanillaColoredPanes.get(color);
    }
}

