/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.mca.MCAClient;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.model.PlayerEntityExtendedModel;
import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.client.render.layer.ClothingLayer;
import forge.net.mca.client.render.layer.FaceLayer;
import forge.net.mca.client.render.layer.HairLayer;
import forge.net.mca.client.render.layer.SkinLayer;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.ai.relationship.AgeState;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerEntityRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    private PlayerModel<AbstractClientPlayer> mca$villagerModel;
    @Unique
    private PlayerModel<AbstractClientPlayer> mca$vanillaModel;
    @Unique
    SkinLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> mca$skinLayer;
    @Unique
    ClothingLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> mca$clothingLayer;

    @Shadow
    protected abstract void m_117818_(AbstractClientPlayer var1);

    public MixinPlayerEntityRenderer(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;Z)V"}, at={@At(value="TAIL")})
    private void init(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        if (MCAClient.isPlayerRendererAllowed()) {
            this.mca$villagerModel = MixinPlayerEntityRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f), slim));
            this.mca$vanillaModel = (PlayerModel)this.f_115290_;
            this.mca$skinLayer = new SkinLayer(this, MixinPlayerEntityRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f))));
            this.m_115326_(this.mca$skinLayer);
            this.m_115326_(new FaceLayer(this, MixinPlayerEntityRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.01f))), "normal"));
            this.mca$clothingLayer = new ClothingLayer(this, MixinPlayerEntityRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0625f))), "normal");
            this.m_115326_(this.mca$clothingLayer);
            this.m_115326_(new HairLayer(this, MixinPlayerEntityRenderer.mca$createModel(VillagerEntityModelMCA.hairData(new CubeDeformation(0.125f)))));
        }
    }

    @Unique
    private static PlayerEntityExtendedModel<AbstractClientPlayer> mca$createModel(MeshDefinition data) {
        return new PlayerEntityExtendedModel<AbstractClientPlayer>(LayerDefinition.m_171565_((MeshDefinition)data, (int)64, (int)64).m_171564_());
    }

    @Inject(method={"scale(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/client/util/math/MatrixStack;F)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectScale(AbstractClientPlayer player, PoseStack matrices, float f, CallbackInfo ci) {
        if (MCAClient.useGeneticsRenderer(player.m_20148_())) {
            float height = CommonVillagerModel.getVillager((Entity)player).getRawScaleFactor();
            float width = CommonVillagerModel.getVillager((Entity)player).getHorizontalScaleFactor();
            matrices.m_85841_(width, height, width);
            if (CommonVillagerModel.getVillager((Entity)player).getAgeState() == AgeState.BABY && !player.m_20159_()) {
                matrices.m_252880_(0.0f, 0.6f, 0.0f);
            }
            ci.cancel();
            this.f_115290_ = this.mca$villagerModel;
        } else if (MCAClient.isPlayerRendererAllowed()) {
            this.f_115290_ = this.mca$vanillaModel;
        }
    }

    @Inject(method={"renderRightArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderRightArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.m_20148_(), "right_arm")) {
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$skinLayer.model).f_102811_, ((PlayerModel)this.mca$skinLayer.model).f_103375_, this.mca$skinLayer);
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$clothingLayer.model).f_102811_, ((PlayerModel)this.mca$clothingLayer.model).f_103375_, this.mca$clothingLayer);
            ci.cancel();
        }
    }

    @Inject(method={"renderLeftArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderLeftArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.m_20148_(), "left_arm")) {
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$skinLayer.model).f_102812_, ((PlayerModel)this.mca$skinLayer.model).f_103374_, this.mca$skinLayer);
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$clothingLayer.model).f_102812_, ((PlayerModel)this.mca$clothingLayer.model).f_103374_, this.mca$clothingLayer);
            ci.cancel();
        }
    }

    @Unique
    private void mca$renderCustomArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, VillagerLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> layer) {
        PlayerEntityExtendedModel model = (PlayerEntityExtendedModel)layer.model;
        this.m_117818_(player);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_(player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        model.applyVillagerDimensions(CommonVillagerModel.getVillager((Entity)player), player.m_6047_());
        ResourceLocation skin = layer.getSkin(player);
        if (layer.canUse(skin)) {
            VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)skin));
            float[] color = layer.getColor(player, 0.0f);
            arm.f_104203_ = 0.0f;
            arm.m_104306_(matrices, buffer, light, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
            sleeve.f_104203_ = 0.0f;
            sleeve.m_104306_(matrices, buffer, light, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }
}

