/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.chatAI;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.chatAI.ChatAIStrategy;
import fabric.net.mca.entity.ai.chatAI.TriggerCommandInfo;
import fabric.net.mca.entity.ai.chatAI.TriggerCommandInfos;
import fabric.net.mca.entity.ai.chatAI.modules.EnvironmentModule;
import fabric.net.mca.entity.ai.chatAI.modules.PersonalityModule;
import fabric.net.mca.entity.ai.chatAI.modules.PlayerModule;
import fabric.net.mca.entity.ai.chatAI.modules.RelationModule;
import fabric.net.mca.entity.ai.chatAI.modules.TraitsModule;
import fabric.net.mca.entity.ai.chatAI.modules.VillageModule;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OpenAIChatAI
implements ChatAIStrategy {
    private static final int MAX_MEMORY = 500;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final Map<UUID, List<class_3545<String, String>>> memory = new HashMap<UUID, List<class_3545<String, String>>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();

    public static String translate(String phrase) {
        return phrase.replace("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    private static HttpURLConnection getHttpURLConnection(String url, String token) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + token);
        con.setDoOutput(true);
        return con;
    }

    private static Answer parseAnswer(String body) {
        StructuredResponse structuredReply;
        String error;
        JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
        String message = map.has("choices") ? map.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").getAsJsonPrimitive("content").getAsString() : null;
        String string = error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
        if (message != null) {
            message = message.replaceAll("```", "");
            int bracketStart = message.indexOf("{");
            int bracketEnd = message.lastIndexOf("}");
            if (bracketEnd > bracketStart && bracketStart != -1) {
                message = message.substring(bracketStart, bracketEnd + 1);
            }
        }
        try {
            structuredReply = (StructuredResponse)new Gson().fromJson(message, StructuredResponse.class);
        }
        catch (JsonSyntaxException e) {
            MCA.LOGGER.warn("Error parsing answer: {} ({})", (Object)message, (Object)e.getMessage());
            structuredReply = new StructuredResponse(OpenAIChatAI.cleanupAnswer(message), "");
        }
        return new Answer(structuredReply, error);
    }

    public static Answer post(String url, String requestBody, String token) {
        try {
            HttpURLConnection con = OpenAIChatAI.getHttpURLConnection(url, token);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.write(requestBody.getBytes(StandardCharsets.UTF_8));
                wr.flush();
            }
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            return OpenAIChatAI.parseAnswer(body);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "Unknown error, check log!");
        }
    }

    public static String verify(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            return map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", " ") : "";
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return "error";
        }
    }

    @Override
    public Optional<String> answer(class_3222 player, VillagerEntityMCA villager, String msg) {
        try {
            List<Object> validCommands;
            Config config = Config.getInstance();
            boolean isInHouse = config.villagerChatAIEndpoint.contains("conczin.net");
            String playerName = player.method_5477().getString();
            String villagerName = villager.method_5477().getString();
            long time = villager.method_37908().method_8510();
            if (time > lastInteractions.getOrDefault(villager.method_5667(), 0L) + 54000L) {
                memory.remove(villager.method_5667());
            }
            lastInteractions.put(villager.method_5667(), time);
            List pastDialogue = memory.computeIfAbsent(villager.method_5667(), key -> new LinkedList());
            while (pastDialogue.stream().mapToInt(v -> ((String)v.method_15441()).length() / 4).sum() > 500) {
                pastDialogue.remove(0);
            }
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            if (isInHouse || config.villagerChatAIIncludeSessionInformation) {
                long seed = player.method_51469().method_8412();
                sb.append("[world_id:").append(seed).append("]");
                sb.append("[player_id:").append(player.method_5667()).append("]");
                sb.append("[character_id:").append(villager.method_5667()).append("]");
                if (config.villagerChatAIUseLongTermMemory) {
                    sb.append("[use_memory:true]");
                }
                if (config.villagerChatAIUseSharedLongTermMemory) {
                    sb.append("[shared_memory:true]");
                }
            }
            if (!config.villagerChatAISystemPrompt.isEmpty()) {
                sb.append(config.villagerChatAISystemPrompt);
                sb.append("\n");
            } else if (!isInHouse) {
                String defaultPrompt = "You are a Minecraft villager, fully immersed in their virtual world, unaware of its artificial nature. You respond based on your description, your role, and your knowledge of the world. You have no knowledge of the real world, and do not realize that you are within Minecraft. You are no assistant! You can be sarcastic, funny, or even rude when appropriate.";
                sb.append(defaultPrompt);
                sb.append("\n");
            }
            for (String s2 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s2 = s2.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s2);
            }
            if (MCA.language != null) {
                sb.append("Match the language of the player, and use ").append(MCA.language).append(" when unsure.");
            }
            if (config.villagerChatAIUseTools) {
                validCommands = TriggerCommandInfos.triggerCommands.stream().filter(c -> c.isActive == null || c.isActive.test(player, villager)).toList();
                MCA.LOGGER.info("Valid commands: {}", validCommands.stream().map(c -> c.command).toList());
            } else {
                validCommands = List.of();
            }
            if (!validCommands.isEmpty()) {
                String structureExample = new Gson().toJson((Object)new StructuredResponse("example message to say", ((TriggerCommandInfo)validCommands.get((int)0)).command));
                sb.append("\n\n");
                sb.append("The reply MUST be in this JSON format: ").append(structureExample).append("\n");
                sb.append("The following commands are valid:\n");
                for (Object command : validCommands) {
                    sb.append("  * ").append(((TriggerCommandInfo)command).command).append(": ").append(((TriggerCommandInfo)command).description).append("\n");
                }
                sb.append("Only use a command when the player asks for it.");
            }
            String system = sb.toString();
            StringBuilder body = new StringBuilder();
            body.append("{");
            body.append("\"model\": \"").append(config.villagerChatAIModel).append("\",");
            body.append("\"messages\": [");
            body.append("{\"role\": \"system\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(system)).append("},");
            for (class_3545 pair : pastDialogue) {
                String role = (String)pair.method_15442();
                String content = (String)pair.method_15441();
                String name = role.equals("user") ? playerName : villagerName;
                body.append("{\"role\": \"").append(role).append("\", \"name\": \"").append(name).append("\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(content)).append("},");
            }
            body.append("{\"role\": \"user\", \"name\": \"").append(playerName).append("\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(msg)).append("}");
            body.append("]");
            body.append("}");
            String token = config.villagerChatAIToken;
            if (token.isEmpty() || config.villagerChatAIEndpoint.contains("conczin.net")) {
                token = player.method_5477().getString();
            }
            Answer message = OpenAIChatAI.post(config.villagerChatAIEndpoint, body.toString(), token);
            if (message.error == null) {
                if (message.answer != null) {
                    pastDialogue.add(new class_3545((Object)"user", (Object)msg));
                    pastDialogue.add(new class_3545((Object)"assistant", (Object)(message.answer.message != null ? message.answer.message : "...")));
                    if (message.answer.optionalCommand() != null && !message.answer.optionalCommand().isEmpty()) {
                        Optional<TriggerCommandInfo> command = TriggerCommandInfos.findCommand(message.answer.optionalCommand(), player, villager);
                        command.ifPresent(triggerCommandInfo -> triggerCommandInfo.call.accept(player, villager));
                    }
                }
                return Optional.ofNullable(message.answer != null ? message.answer.message : null);
            }
            if (message.error.equals("invalid_model")) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Invalid model!").method_27692(class_124.field_1061), false);
            } else if (message.error.equals("limit")) {
                class_5250 styled = class_2561.method_43471((String)"mca.limit.patreon").method_27694(s -> s.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"mca.limit.patreon.hover"))));
                player.method_7353((class_2561)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.method_7353((class_2561)class_2561.method_43471((String)"mca.limit.premium").method_27692(class_124.field_1061), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)message.error).method_27692(class_124.field_1061), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error("Failed to parse LLM response!", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43471((String)"mca.ai_broken").method_27692(class_124.field_1061), false);
        }
        return Optional.empty();
    }

    static String jsonStringQuote(String string) {
        StringBuilder sb = new StringBuilder("\"");
        for (char c : string.toCharArray()) {
            sb.append(switch (c) {
                case '\"', '/', '\\' -> "\\" + c;
                case '\b' -> "\\b";
                case '\t' -> "\\t";
                case '\n' -> "\\n";
                case '\f' -> "\\f";
                case '\r' -> "\\r";
                default -> c < ' ' ? String.format(Locale.ROOT, "\\u%04x", Character.valueOf(c)) : Character.valueOf(c);
            });
        }
        return sb.append('\"').toString();
    }

    static String cleanupAnswer(String answer) {
        if (answer == null) {
            return null;
        }
        answer = answer.replace("\"", "");
        answer = answer.replace("\n", " ");
        String[] parts = answer.split(":", 2);
        return parts[parts.length - 1].strip();
    }

    public record StructuredResponse(@Nullable String message, String optionalCommand) {
    }

    public record Answer(StructuredResponse answer, String error) {
    }
}

