/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemNameAttribute
implements ItemAttribute {
    private String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    private static String extractCustomName(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        if (compoundnbt != null && compoundnbt.m_128425_("Name", 8)) {
            try {
                MutableComponent itextcomponent = Component.Serializer.m_130701_((String)compoundnbt.m_128461_("Name"));
                if (itextcomponent != null) {
                    return itextcomponent.getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return ItemNameAttribute.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_NAME;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128359_("name", this.itemName);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.itemName = nbt.m_128461_("name");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemNameAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = ItemNameAttribute.extractCustomName(stack);
            if (!name.isEmpty()) {
                list.add(new ItemNameAttribute(name));
            }
            return list;
        }
    }
}

