/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.harvester;

import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterActorVisual;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterRenderer;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.CropBlockAccessor;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
implements MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return MovementBehaviour.super.isActive(context) && !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122424_());
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122436_()).m_82490_(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        if (world.f_46443_) {
            return;
        }
        BlockState stateVisited = world.m_8055_(pos);
        if (stateVisited.m_60795_() || AllTags.AllBlockTags.NON_HARVESTABLE.matches(stateVisited)) {
            return;
        }
        boolean notCropButCuttable = false;
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        ItemStack item = ItemStack.f_41583_;
        float effectChance = 1.0f;
        if (stateVisited.m_204336_(BlockTags.f_13035_)) {
            item = new ItemStack((ItemLike)Items.f_42574_);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlockAs(world, pos, null, item, effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem(stack, new ItemStack((ItemLike)state.m_60734_()))) {
                stack.m_41774_(1);
                seedSubtracted.setTrue();
            }
            this.dropItem(context, (ItemStack)stack);
        });
        BlockState cutCrop = this.cutCrop(world, pos, stateVisited);
        world.m_46597_(pos, cutCrop.m_60710_((LevelReader)world, pos) ? cutCrop : Blocks.f_50016_.m_49966_());
    }

    public boolean isValidCrop(Level world, BlockPos pos, BlockState state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (harvestPartial) {
                return state != crop.m_52289_(0) || !replant;
            }
            return crop.m_52307_(state);
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || state.m_60734_() instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty ageProperty = (IntegerProperty)property;
                if (!property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                int age = (Integer)state.m_61143_((Property)ageProperty);
                if (state.m_60734_() instanceof SweetBerryBushBlock && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.m_6908_().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidOther(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof CropBlock) {
            return false;
        }
        if (state.m_60734_() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        if (state.m_60734_() instanceof CocoaBlock) {
            return (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 2;
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_()) {
            if (state.m_60734_() instanceof GrowingPlantBlock) {
                return true;
            }
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return false;
            }
            if (state.m_60734_() instanceof IPlantable) {
                return true;
            }
        }
        return false;
    }

    private BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockState newState = crop.m_52289_(0);
            if (!newState.m_60713_(block)) {
                return newState;
            }
            IntegerProperty ageProperty = ((CropBlockAccessor)crop).create$callGetAgeProperty();
            return (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0));
        }
        if (block == Blocks.f_50685_) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(1));
        }
        if (AllTags.AllBlockTags.SUGAR_CANE_VARIANTS.matches(block) || block instanceof GrowingPlantBlock) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || block instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return (BlockState)state.m_61124_((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.m_60819_().m_76178_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return state.m_60819_().m_76188_();
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            HarvesterRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new HarvesterActorVisual(visualizationContext, simulationWorld, movementContext);
    }
}

