/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.custom_worldgen.server;

import com.hexagram2021.custom_worldgen.common.utils.CWGLogger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import org.slf4j.Logger;

public final class CWGCommands {
    private static final String POSITION = "pos";

    private CWGCommands() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cwg").requires(stack -> stack.m_6761_(2))).then(Commands.m_82127_((String)"noise").then(Commands.m_82129_((String)POSITION, (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> CWGCommands.getWorldgenNoise(((CommandSourceStack)context.getSource()).m_230896_(), ((CommandSourceStack)context.getSource()).m_81372_(), BlockPosArgument.m_264582_((CommandContext)context, (String)POSITION)))));
    }

    private static int getWorldgenNoise(@Nullable ServerPlayer player, ServerLevel level, BlockPos blockPos) {
        int x = QuartPos.m_175400_((int)blockPos.m_123341_());
        int y = QuartPos.m_175400_((int)blockPos.m_123342_());
        int z = QuartPos.m_175400_((int)blockPos.m_123343_());
        Climate.TargetPoint targetPoint = level.m_7726_().m_214994_().m_224579_().m_183445_(x, y, z);
        float c = Climate.m_186796_((long)targetPoint.f_187005_());
        float e = Climate.m_186796_((long)targetPoint.f_187006_());
        float t = Climate.m_186796_((long)targetPoint.f_187003_());
        float h = Climate.m_186796_((long)targetPoint.f_187004_());
        float w = Climate.m_186796_((long)targetPoint.f_187008_());
        Consumer<String> printer = player == null ? arg_0 -> ((Logger)CWGLogger.LOGGER).info(arg_0) : msg -> player.m_213846_((Component)Component.m_237113_((String)msg));
        OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
        CWGCommands.printDebugInfoTo(printer, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), overworldBiomeBuilder, c, e, t, h, w);
        return 1;
    }

    private static void printDebugInfoTo(Consumer<String> printer, int x, int y, int z, OverworldBiomeBuilder overworldBiomeBuilder, float c, float e, float t, float h, float w) {
        printer.accept("The worldgen noise parameters of block position (%d, %d, %d) is:".formatted(x, y, z));
        printer.accept("  Continentalness: %-8.4f (%s)".formatted(Float.valueOf(c), overworldBiomeBuilder.m_187189_((double)c)));
        printer.accept("          Erosion: %-8.4f (%s)".formatted(Float.valueOf(e), overworldBiomeBuilder.m_187209_((double)e)));
        printer.accept("      Temperature: %-8.4f (%s)".formatted(Float.valueOf(t), overworldBiomeBuilder.m_187220_((double)t)));
        printer.accept("         Humidity: %-8.4f (%s)".formatted(Float.valueOf(h), overworldBiomeBuilder.m_187231_((double)h)));
        printer.accept("        Weirdness: %-8.4f (%s)".formatted(Float.valueOf(w), OverworldBiomeBuilder.m_187155_((double)NoiseRouterData.m_224435_((float)w))));
    }
}

