/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.custom_worldgen.mixin;

import com.google.common.collect.ImmutableList;
import com.hexagram2021.custom_worldgen.common.config.CWGCommonConfig;
import com.hexagram2021.custom_worldgen.common.utils.CWGLogger;
import com.hexagram2021.custom_worldgen.mixin.accessors.CubicSplineMultipointAccessor;
import com.hexagram2021.custom_worldgen.mixin.accessors.NoiseGeneratorSettingsAccess;
import com.hexagram2021.custom_worldgen.mixin.accessors.NoiseParametersAccess;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.CubicSpline;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={WorldLoader.class})
public abstract class WorldLoaderMixin {
    private static final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private static final float[] offsetLocations = new float[]{-1.1f, -1.02f, -0.51f, -0.44f, -0.18f, -0.16f, -0.15f, -0.1f, 0.25f, 1.0f};
    private static final float[] factorLocations = new float[]{-0.19f, -0.15f, -0.1f, 0.03f, 0.06f};
    private static final float[] jaggednessLocations = new float[]{-0.11f, 0.03f, 0.65f};

    @Shadow
    private static LayeredRegistryAccess<RegistryLayer> m_245736_(ResourceManager p_249913_, LayeredRegistryAccess<RegistryLayer> p_252077_, RegistryLayer p_250346_, List<RegistryDataLoader.RegistryData<?>> p_250589_) {
        throw new UnsupportedOperationException("Replaced by Mixin");
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/WorldLoader;loadAndReplaceLayer(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/core/LayeredRegistryAccess;Lnet/minecraft/server/RegistryLayer;Ljava/util/List;)Lnet/minecraft/core/LayeredRegistryAccess;"))
    private static LayeredRegistryAccess<RegistryLayer> modifyLoadedParameters(ResourceManager resourceManager, LayeredRegistryAccess<RegistryLayer> registryAccess, RegistryLayer registryLayer, List<RegistryDataLoader.RegistryData<?>> registryData) {
        LayeredRegistryAccess<RegistryLayer> res = WorldLoaderMixin.m_245736_(resourceManager, registryAccess, registryLayer, registryData);
        RegistryAccess.Frozen frozen = res.m_245283_((Object)registryLayer);
        Registry noiseParametersRegistry = frozen.m_175515_(Registries.f_256865_);
        NormalNoise.NoiseParameters temperature = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189269_);
        NormalNoise.NoiseParameters temperatureLarge = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189281_);
        NormalNoise.NoiseParameters humidity = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189278_);
        NormalNoise.NoiseParameters humidityLarge = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189282_);
        NormalNoise.NoiseParameters continentalness = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189279_);
        NormalNoise.NoiseParameters continentalnessLarge = (NormalNoise.NoiseParameters)noiseParametersRegistry.m_123013_(Noises.f_189283_);
        ((NoiseParametersAccess)temperature).setFirstOctave(temperature.f_192853_() + CWGCommonConfig.OCTAVE_TEMPERATURE_ADDER.value());
        ((NoiseParametersAccess)temperatureLarge).setFirstOctave(temperatureLarge.f_192853_() + CWGCommonConfig.OCTAVE_TEMPERATURE_ADDER.value());
        ((NoiseParametersAccess)humidity).setFirstOctave(humidity.f_192853_() + CWGCommonConfig.OCTAVE_HUMIDITY_ADDER.value());
        ((NoiseParametersAccess)humidityLarge).setFirstOctave(humidityLarge.f_192853_() + CWGCommonConfig.OCTAVE_HUMIDITY_ADDER.value());
        ((NoiseParametersAccess)continentalness).setFirstOctave(continentalness.f_192853_() + CWGCommonConfig.OCTAVE_CONTINENTALNESS_ADDER.value());
        ((NoiseParametersAccess)continentalnessLarge).setFirstOctave(continentalnessLarge.f_192853_() + CWGCommonConfig.OCTAVE_CONTINENTALNESS_ADDER.value());
        Registry noiseGeneratorSettingsRegistry = frozen.m_175515_(Registries.f_256932_);
        NoiseGeneratorSettings overworld = (NoiseGeneratorSettings)noiseGeneratorSettingsRegistry.m_123013_(NoiseGeneratorSettings.f_64432_);
        ImmutableList.Builder builder = ImmutableList.builder();
        Climate.Parameter surface = Climate.Parameter.m_186820_((float)0.0f);
        float weirdnessGap = 0.16f;
        builder.add((Object)new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186822_((float)CWGCommonConfig.COAST_TO_INLAND_CONTINENTALNESS.value().floatValue(), (float)1.0f), FULL_RANGE, surface, Climate.Parameter.m_186822_((float)-1.0f, (float)(-weirdnessGap)), 0L));
        builder.add((Object)new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186822_((float)CWGCommonConfig.COAST_TO_INLAND_CONTINENTALNESS.value().floatValue(), (float)1.0f), FULL_RANGE, surface, Climate.Parameter.m_186822_((float)weirdnessGap, (float)1.0f), 0L));
        if (CWGCommonConfig.ENABLE_MUSHROOM_FIELDS_SPAWN.value().booleanValue()) {
            builder.add((Object)new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186822_((float)-1.2f, (float)CWGCommonConfig.MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS.value().floatValue()), FULL_RANGE, surface, Climate.Parameter.m_186822_((float)-1.0f, (float)(-weirdnessGap)), 0L));
            builder.add((Object)new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186822_((float)-1.2f, (float)CWGCommonConfig.MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS.value().floatValue()), FULL_RANGE, surface, Climate.Parameter.m_186822_((float)weirdnessGap, (float)1.0f), 0L));
        }
        ((NoiseGeneratorSettingsAccess)overworld).setSpawnTarget((List<Climate.ParameterPoint>)builder.build());
        Registry densityFunctionRegistry = frozen.m_175515_(Registries.f_257040_);
        DensityFunction overworldOffset = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224430_);
        DensityFunction overworldLargeOffset = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224419_);
        DensityFunction overworldAmplifiedOffset = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224421_);
        DensityFunction overworldFactor = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_209454_);
        DensityFunction overworldLargeFactor = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_209459_);
        DensityFunction overworldAmplifiedFactor = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224422_);
        DensityFunction overworldJaggedness = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224431_);
        DensityFunction overworldLargeJaggedness = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224420_);
        DensityFunction overworldAmplifiedJaggedness = (DensityFunction)densityFunctionRegistry.m_123013_(NoiseRouterData.f_224423_);
        WorldLoaderMixin.modifyOverworldOffset(overworldOffset);
        WorldLoaderMixin.modifyOverworldOffset(overworldLargeOffset);
        WorldLoaderMixin.modifyOverworldOffset(overworldAmplifiedOffset);
        WorldLoaderMixin.modifyOverworldFactor(overworldFactor);
        WorldLoaderMixin.modifyOverworldFactor(overworldLargeFactor);
        WorldLoaderMixin.modifyOverworldFactor(overworldAmplifiedFactor);
        WorldLoaderMixin.modifyOverworldJaggedness(overworldJaggedness);
        WorldLoaderMixin.modifyOverworldJaggedness(overworldLargeJaggedness);
        WorldLoaderMixin.modifyOverworldJaggedness(overworldAmplifiedJaggedness);
        CWGLogger.LOGGER.debug("Successfully applied config values to worldgen.");
        return res;
    }

    private static void modifyOverworldOffset(DensityFunction offset) {
        WorldLoaderMixin.convertDirectWrappedDensityFunctionAndRun(offset, flat_cache -> WorldLoaderMixin.convertWrappedDensityFunctionAndRun(flat_cache.m_207056_(), cache_2d -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(cache_2d.m_207056_(), mul -> WorldLoaderMixin.convertAp2DensityFunctionAndRunLeft(mul, add -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(add, spline -> {
            CubicSpline patt7903$temp;
            DensityFunctions.HolderHolder holderHolder;
            Object patt7816$temp;
            if (spline instanceof DensityFunctions.HolderHolder && (patt7816$temp = (holderHolder = (DensityFunctions.HolderHolder)spline).f_208636_().get()) instanceof DensityFunctions.Spline) {
                DensityFunctions.Spline continents = (DensityFunctions.Spline)patt7816$temp;
                patt7903$temp = continents.f_211702_();
                if (!(patt7903$temp instanceof CubicSpline.Multipoint)) {
                    throw new ClassCastException("Cannot convert " + continents.f_211702_() + " to " + CubicSpline.Multipoint.class.getName());
                }
            } else {
                throw new ClassCastException("Cannot convert " + spline + " to " + DensityFunctions.Spline.class.getName());
            }
            CubicSpline.Multipoint multipoint = (CubicSpline.Multipoint)patt7903$temp;
            WorldLoaderMixin.solveTerrainOffsetCubicSplines((CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate>)multipoint);
        })))));
    }

    private static void modifyOverworldFactor(DensityFunction factor) {
        WorldLoaderMixin.convertDirectWrappedDensityFunctionAndRun(factor, flat_cache -> WorldLoaderMixin.convertWrappedDensityFunctionAndRun(flat_cache.m_207056_(), cache_2d -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(cache_2d.m_207056_(), mul -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(mul, add -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(add, spline -> {
            CubicSpline patt9124$temp;
            DensityFunctions.HolderHolder holderHolder;
            Object patt9037$temp;
            if (spline instanceof DensityFunctions.HolderHolder && (patt9037$temp = (holderHolder = (DensityFunctions.HolderHolder)spline).f_208636_().get()) instanceof DensityFunctions.Spline) {
                DensityFunctions.Spline continents = (DensityFunctions.Spline)patt9037$temp;
                patt9124$temp = continents.f_211702_();
                if (!(patt9124$temp instanceof CubicSpline.Multipoint)) {
                    throw new ClassCastException("Cannot convert " + continents.f_211702_() + " to " + CubicSpline.Multipoint.class.getName());
                }
            } else {
                throw new ClassCastException("Cannot convert " + spline + " to " + DensityFunctions.Spline.class.getName());
            }
            CubicSpline.Multipoint multipoint = (CubicSpline.Multipoint)patt9124$temp;
            WorldLoaderMixin.solveTerrainFactorCubicSplines((CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate>)multipoint);
        })))));
    }

    private static void modifyOverworldJaggedness(DensityFunction factor) {
        WorldLoaderMixin.convertDirectWrappedDensityFunctionAndRun(factor, flat_cache -> WorldLoaderMixin.convertWrappedDensityFunctionAndRun(flat_cache.m_207056_(), cache_2d -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(cache_2d.m_207056_(), mul -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(mul, add -> WorldLoaderMixin.convertAp2DensityFunctionAndRunRight(add, spline -> {
            CubicSpline patt10349$temp;
            DensityFunctions.HolderHolder holderHolder;
            Object patt10262$temp;
            if (spline instanceof DensityFunctions.HolderHolder && (patt10262$temp = (holderHolder = (DensityFunctions.HolderHolder)spline).f_208636_().get()) instanceof DensityFunctions.Spline) {
                DensityFunctions.Spline continents = (DensityFunctions.Spline)patt10262$temp;
                patt10349$temp = continents.f_211702_();
                if (!(patt10349$temp instanceof CubicSpline.Multipoint)) {
                    throw new ClassCastException("Cannot convert " + continents.f_211702_() + " to " + CubicSpline.Multipoint.class.getName());
                }
            } else {
                throw new ClassCastException("Cannot convert " + spline + " to " + DensityFunctions.Spline.class.getName());
            }
            CubicSpline.Multipoint multipoint = (CubicSpline.Multipoint)patt10349$temp;
            WorldLoaderMixin.solveTerrainJaggednessCubicSplines((CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate>)multipoint);
        })))));
    }

    private static void equalsOrThrow(float origin, float checked) {
        float diff = origin - checked;
        if (diff < -1.0E-5f || diff > 1.0E-5f) {
            throw new IllegalStateException("Failed to check compatibility: location values changed by datapacks. Please do NOT install other datapacks to modify terrain with our Custom World Generation Mod.");
        }
    }

    private static void solveTerrainOffsetCubicSplines(CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate> multipoint) {
        float[] newLocations = new float[]{offsetLocations[0], CWGCommonConfig.MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER.value().floatValue(), CWGCommonConfig.DEEP_OCEAN_TO_OCEAN_SHAPER.value().floatValue(), CWGCommonConfig.OCEAN_TO_COAST_SHAPER.value().floatValue(), CWGCommonConfig.COAST_WATER_SHAPER.value().floatValue(), CWGCommonConfig.COAST_BANK_SHAPER.value().floatValue(), CWGCommonConfig.COAST_LAND_SHAPER.value().floatValue(), CWGCommonConfig.NEAR_INLAND_SHAPER.value().floatValue(), CWGCommonConfig.MID_INLAND_SHAPER.value().floatValue(), offsetLocations[9]};
        if (multipoint.f_184320_().length != offsetLocations.length) {
            throw new IllegalStateException("Failed to check compatibility: cubic spline location count changed by datapacks. Please do NOT install other datapacks to modify terrain with our Custom World Generation Mod.");
        }
        for (int i = 0; i < multipoint.f_184320_().length; ++i) {
            WorldLoaderMixin.equalsOrThrow(multipoint.f_184320_()[i], offsetLocations[i]);
        }
        ((CubicSplineMultipointAccessor)multipoint).setLocations(newLocations);
    }

    private static void solveTerrainFactorCubicSplines(CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate> multipoint) {
        float[] newLocations = new float[]{CWGCommonConfig.OCEAN_TO_COAST_CONTINENTALNESS.value().floatValue(), CWGCommonConfig.COAST_LAND_SHAPER.value().floatValue(), CWGCommonConfig.NEAR_INLAND_SHAPER.value().floatValue(), CWGCommonConfig.NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS.value().floatValue(), CWGCommonConfig.INLAND_EROSION_SHAPER.value().floatValue()};
        if (multipoint.f_184320_().length != factorLocations.length) {
            throw new IllegalStateException("Failed to check compatibility: cubic spline location count changed by datapacks. Please do NOT install other datapacks to modify terrain with our Custom World Generation Mod.");
        }
        for (int i = 0; i < multipoint.f_184320_().length; ++i) {
            WorldLoaderMixin.equalsOrThrow(multipoint.f_184320_()[i], factorLocations[i]);
        }
        ((CubicSplineMultipointAccessor)multipoint).setLocations(newLocations);
    }

    private static void solveTerrainJaggednessCubicSplines(CubicSpline.Multipoint<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate> multipoint) {
        float[] newLocations = new float[]{CWGCommonConfig.COAST_TO_INLAND_CONTINENTALNESS.value().floatValue(), CWGCommonConfig.NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS.value().floatValue(), CWGCommonConfig.PEAKS_EROSION_SHAPER.value().floatValue()};
        if (multipoint.f_184320_().length != jaggednessLocations.length) {
            throw new IllegalStateException("Failed to check compatibility: cubic spline location count changed by datapacks. Please do NOT install other datapacks to modify terrain with our Custom World Generation Mod.");
        }
        for (int i = 0; i < multipoint.f_184320_().length; ++i) {
            WorldLoaderMixin.equalsOrThrow(multipoint.f_184320_()[i], jaggednessLocations[i]);
        }
        ((CubicSplineMultipointAccessor)multipoint).setLocations(newLocations);
    }

    private static void convertDirectWrappedDensityFunctionAndRun(DensityFunction densityFunction, Consumer<DensityFunctions.MarkerOrMarked> consumer) {
        if (!(densityFunction instanceof DensityFunctions.MarkerOrMarked)) {
            throw new ClassCastException("Cannot convert " + densityFunction + " to " + DensityFunctions.MarkerOrMarked.class.getName());
        }
        DensityFunctions.MarkerOrMarked converted = (DensityFunctions.MarkerOrMarked)densityFunction;
        consumer.accept(converted);
    }

    private static void convertWrappedDensityFunctionAndRun(DensityFunction densityFunction, Consumer<DensityFunctions.MarkerOrMarked> consumer) {
        DensityFunctions.HolderHolder holderHolder;
        Object object;
        if (!(densityFunction instanceof DensityFunctions.HolderHolder) || !((object = (holderHolder = (DensityFunctions.HolderHolder)densityFunction).f_208636_().get()) instanceof DensityFunctions.MarkerOrMarked)) {
            throw new ClassCastException("Cannot convert " + densityFunction + " to " + DensityFunctions.MarkerOrMarked.class.getName());
        }
        DensityFunctions.MarkerOrMarked converted = (DensityFunctions.MarkerOrMarked)object;
        consumer.accept(converted);
    }

    private static void convertAp2DensityFunctionAndRunLeft(DensityFunction densityFunction, Consumer<DensityFunction> consumer) {
        DensityFunctions.HolderHolder holderHolder;
        Object object;
        if (!(densityFunction instanceof DensityFunctions.HolderHolder) || !((object = (holderHolder = (DensityFunctions.HolderHolder)densityFunction).f_208636_().get()) instanceof DensityFunctions.TwoArgumentSimpleFunction)) {
            throw new ClassCastException("Cannot convert " + densityFunction + " to " + DensityFunctions.TwoArgumentSimpleFunction.class.getName());
        }
        DensityFunctions.TwoArgumentSimpleFunction ap2 = (DensityFunctions.TwoArgumentSimpleFunction)object;
        consumer.accept(ap2.m_207185_());
    }

    private static void convertAp2DensityFunctionAndRunRight(DensityFunction densityFunction, Consumer<DensityFunction> consumer) {
        DensityFunctions.HolderHolder holderHolder;
        Object object;
        if (!(densityFunction instanceof DensityFunctions.HolderHolder) || !((object = (holderHolder = (DensityFunctions.HolderHolder)densityFunction).f_208636_().get()) instanceof DensityFunctions.TwoArgumentSimpleFunction)) {
            throw new ClassCastException("Cannot convert " + densityFunction + " to " + DensityFunctions.TwoArgumentSimpleFunction.class.getName());
        }
        DensityFunctions.TwoArgumentSimpleFunction ap2 = (DensityFunctions.TwoArgumentSimpleFunction)object;
        consumer.accept(ap2.m_207190_());
    }
}

