/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.custom_worldgen.conditionalmixin;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.util.Annotations;

public class AnnotationHelper {
    private final Class<? extends Annotation> annotationClass;
    @Nullable
    private AnnotationNode previousRestrictionAnnotation;

    public AnnotationHelper(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void onPreApply(ClassNode targetClass) {
        this.previousRestrictionAnnotation = Annotations.getVisible((ClassNode)targetClass, this.annotationClass);
    }

    public void onPostApply(ClassNode targetClass) {
        String descriptor = Type.getDescriptor(this.annotationClass);
        List annotationNodes = targetClass.visibleAnnotations;
        if (annotationNodes == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < annotationNodes.size(); ++i) {
            if (!descriptor.equals(((AnnotationNode)annotationNodes.get((int)i)).desc)) continue;
            index = i;
            break;
        }
        if (this.previousRestrictionAnnotation == null && index != -1) {
            annotationNodes.remove(index);
        } else if (this.previousRestrictionAnnotation != null) {
            annotationNodes.set(index, this.previousRestrictionAnnotation);
        }
    }
}

