/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.custom_worldgen.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nullable;

public interface IConfigHelper {
    public static void writeJsonToFile(Writer writer, @Nullable String key, JsonElement json, int tab) throws IOException {
        writer.write("\t".repeat(tab));
        if (key != null) {
            writer.write("\"" + key + "\": ");
        }
        if (json.isJsonObject()) {
            writer.write("{\n");
            boolean first = true;
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(",\n");
                }
                IConfigHelper.writeJsonToFile(writer, (String)entry.getKey(), (JsonElement)entry.getValue(), tab + 1);
            }
            writer.write("\n" + "\t".repeat(tab) + "}");
        } else if (json.isJsonArray()) {
            writer.write("[\n");
            boolean first = true;
            for (JsonElement element : json.getAsJsonArray()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(",\n");
                }
                IConfigHelper.writeJsonToFile(writer, null, element, tab + 1);
            }
            writer.write("\n" + "\t".repeat(tab) + "]");
        } else if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                writer.write(String.valueOf(jsonPrimitive.getAsBoolean()));
            } else if (jsonPrimitive.isNumber()) {
                writer.write(String.valueOf(jsonPrimitive.getAsNumber().floatValue()));
            } else if (jsonPrimitive.isString()) {
                writer.write("\"" + jsonPrimitive.getAsString() + "\"");
            }
        }
    }
}

